/**
 * @file bsp_bluetank.h
 * @author takemasa
 * @brief TUNA-CAN および TOL-POT4ブレッドボード用のリソース
 * @details
 * ここにはBSP専用のリソースを置く。実際にはボードの初期化子を置く。
 */

/**
 * @mainpage
 * TUNA-CANおよびTOL-POT4ブレッドボード用のBSP (Board Support Package)
 *
 * Uzumeを使う上のBSPは以下の構成になっている
 * @li uzume/bsp_tunacan_pot4.cfg アプリケーションから読み込むべき
 * 静的コンフィギュレーション・ファイル
 * @li config/blackfin/bsp_tunacan_pot4 BSPのシステム依存部
 * @li uzume_callback.c ユーザー用オーディオコールバックと初期化部の実装
 * @li uzume_app.c ユーザーアプリケーションが使うタスク。
 * @li uzume_app.cfg アプリケーション
 *
 * BSPを使う場合には、次のようにする
 * @li システム依存部から適切なBSPを選ぶ。
 * インクルードする
 * @li configure_projectを実行する。この時にすでに選んだBSP名を引数として与える
 *
 * これでプロジェクトがmake可能になる。
 *
 * 信号処理のアルゴリズムは uzume_callback.c のなかの process_audio() に記述する。
 * また、信号処理の前に初期以下が必要であれば init_audio() に初期化コードを記述する。
 */
#ifndef BSP_TUNACAN_POT4_H
#define BSP_TUNACAN_POT4_H

/**
 * \breif ボリューム入力のチャンネル数
 * \details
 * BSPが持つボリュームのチャンネル数。ここでいうボリュームはポテンショメータに限らない。
 * ロータリーエンコーダーなども含む。また、システムが複数種のボリューム（例えばADCと
 * ロータリーエンコーダー）を持つ場合には、それらのチャンネル数の総和である。
 */

#define UZUME_NUM_VOLUME 4

/**
 * \brief ボード・イニシャライザ
 * \param exinf 0を渡す。関数からは無視される。
 * \details
 * BSP用のイニシャライザである。アプリケーションに依存せず、uzumeが
 * 必要とする初期化処理をおここで行う。具体的にはI2S用のピンの割付を行う
 */
void board_initialize(VP_INT exinf);

#endif /* BSP_BLUETANK_H */

