/**
 * @file bsp_bluetank.c
 * @author takemasa
 * @brief TUNA-CANボード用のリソース
 * @details
 * ここにはBSP専用のリソースを置く。実際にはボードの初期化子を置く。
 */
#include <s_services.h>
#include <t_services.h>
#include <cdefBF592-A.h>
#include <bsp_tunacan_pot4.h>
#include <ad7999.h>

void board_initialize(VP_INT exinf)
{
    // ADSP-BF592 PORTF設定w
    // DR1PRI, RSCK1, RFS1, TD1PRI, TSCK1, TSF0をMUXで0 ( Primary func )にする
    *pPORTF_MUX &= ~0x00ee;

    // ADSP-BF592 PORTG設定
    // DR0PRI, RSCK0, RFS0, TD0PRI, TSCK0, TSF0をFERでイネーブルにする
    *pPORTF_FER |= 0x00ee;

    // ADSP-BF592 EXTCLK設定
    // このピンをイネーブルにし、CLKBUF設定にしないとコーデックにクロックが供給されない。
    *pVR_CTL = EXTCLK_OE | HIBERNATEB;

}

/**
 * \brief ボリューム値の取得
 * \param ch 0から始まるチャンネル指定番号。このBSPはボリュームを4個持っているだけなので、
 * 3までのインデックスを扱う
 */

fract32 get_volume(unsigned int ch)
{
    if ( ch >= UZUME_NUM_VOLUME)
        return 0;

    return ( ad7999_get_volume( ch ) );
}

/**
 * \brief ボリューム値の設定
 * \param ch 0から始まるチャンネル指定番号。AD7999は3まで
 * \param value 32bit符号付き固定小数点数のボリューム設定値
 * \details
 * ボリュームに初期値を与える。
 */

void set_volume(unsigned int ch, fract32 value)
{
}

