/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  TOPPERS/JSP for Blackfin
 *
 *  Copyright (C) 2004,2006,2006 by Takemasa Nakamura
 *  Copyright (C) 2004 by Ujinosuke
 *
 *  上記著作権者は，以下の (1)〜(4) の条件か，Free Software Foundation
 *  によって公表されている GNU General Public License の Version 2 に記
 *  述されている条件を満たす場合に限り，本ソフトウェア（本ソフトウェア
 *  を改変したものを含む．以下同じ）を使用・複製・改変・再配布（以下，
 *  利用と呼ぶ）することを無償で許諾する．
 *  (1) 本ソフトウェアをソースコードの形で利用する場合には，上記の著作
 *      権表示，この利用条件および下記の無保証規定が，そのままの形でソー
 *      スコード中に含まれていること．
 *  (2) 本ソフトウェアを，ライブラリ形式など，他のソフトウェア開発に使
 *      用できる形で再配布する場合には，再配布に伴うドキュメント（利用
 *      者マニュアルなど）に，上記の著作権表示，この利用条件および下記
 *      の無保証規定を掲載すること．
 *  (3) 本ソフトウェアを，機器に組み込むなど，他のソフトウェア開発に使
 *      用できない形で再配布する場合には，次のいずれかの条件を満たすこ
 *      と．
 *    (a) 再配布に伴うドキュメント（利用者マニュアルなど）に，上記の著
 *        作権表示，この利用条件および下記の無保証規定を掲載すること．
 *    (b) 再配布の形態を，別に定める方法によって，TOPPERSプロジェクトに
 *        報告すること．
 *  (4) 本ソフトウェアの利用により直接的または間接的に生じるいかなる損
 *      害からも，上記著作権者およびTOPPERSプロジェクトを免責すること．
 *
 *  本ソフトウェアは，無保証で提供されているものである．上記著作権者お
 *  よびTOPPERSプロジェクトは，本ソフトウェアに関して，その適用可能性も
 *  含めて，いかなる保証も行わない．また，本ソフトウェアの利用により直
 *  接的または間接的に生じたいかなる損害に関しても，その責任を負わない．
 *
 *
 */


#ifndef _SYS_CONFIG_H_
#define _SYS_CONFIG_H_

/*
 *  カーネルの内部識別名のリネーム
 */
#include <sys_rename.h>

/* blackfin/_common_bf533から読み込む */
#include <chip_config.h>

/*
 *  ターゲットシステム依存モジュール（BSP-BLUETANK用）
 *
 *  このインクルードファイルは，t_config.h のみからインクルードされる．
 *  他のファイルから直接インクルードしてはならない．
*/

/*
 * どのようなクロック入力にも対応できるよう、以下でCSEL, SSEL, MSELの値
 * とクロック入力周波数(Hz)を指定する。PLLのプログラムはsys_config.cの
 * sys_initialize()関数で行われる。
 *
 * CSELVALは1,2,4,8の中から選ぶ。CLKINの単位はHz
 */

#define CSELVAL 1
#define SSELVAL 4
#define MSELVAL 16
#define CLKIN 25000000

/*
 * Uzumeコンフィギュレーションマクロ群
 *
 * Uzumeの各機能モジュールはハードウェアに応じた自由度を持っている。それらの設定をデフォルト以外で
 * 使う場合には引数となるマクロをシステム依存部のsys_config.hで宣言する。
 *
 * UZUME_INT_BITS はaudio_callback()の引数として渡されるオーディオ・サンプルの整数値の何ビット取るか
 * 指定する。デフォルトは0である。符号部を除く整数部を7ビット取りたければ、7を指定する。
 *
 * UZUME_BLOCKSIZE は一回のDMA転送で転送するデータのサンプル数である。ステレオデータなので、実際に転送する
 * データ数は UZUME_BLOCKSIZEで指定した量の倍のデータである。48kHzサンプルの場合に48を指定すると、1m秒に
 * 一回割り込みがかかる。
 *
 * UZUME_UZUME_SGTL5000_I2C_ADRS はSGTL5000 コーデックの I2Cデバイスアドレスである。7bitアドレスを右詰めで表現する
 * デフォルトは0x0A
 *
 * UZUME_AD7999_I2C_ADRS はAD7999 ADCの I2Cデバイスアドレスである。7bitアドレスを右詰めで表現する。
 * デフォルトは 0x28
 *
 * その他、I2Cペリフェラルのポート番号を指定するマクロもあるが、2012年時点で0以外には対応していないので
 * ここでは説明しない。
 */

//#define UZUME_BLOCKSIZE 64
//#define UZUME_INT_BITS 0
//#define UZUME_SGTL5000_I2C_ADRS   0x0A

// #define MAIN_TASK_PRIORITY    7
// #define LOGTASK_PRIORITY      5
// #define CODEC_TASK_PRIORITY   4

// #define MAIN_TASK_STACK_SIZE   1024
// #define LOGTASK_STACK_SIZE     1024
// #define CODEC_TASK_STACK_SIZE  1024

/*
 * システムタイマーの選択
 * USE_TIC_COREをdefineすると、COREタイマーが使用される
 * コメントアウトすると、GP_TIMER_2を使用する
 *
 * COREタイマーはwakeup信号を生成しないため、ディスパッチャ
 * はidle命令を使ってCOREタイマーイベントを待つことができない。
 * そのため、USE_TIC_COREを使うとディスパッチャはidle命令を
 * 使わずに割り込み発生をポーリングで待つ。これは消費電力の
 * 点で不利である。
 *
 * システムタイマーにコアタイマーを使うことは、推奨しない。
 * この機能は、移植時の利便性のために残しており、実アプリケーションで
 * つかうことは想定していない。
 *
 */
//#define USE_TIC_CORE

/*
 * ハードウェア・エラー割り込みの許可
 * QUICK_HW_ERRORをdefineすると、ハードウェア・エラー・イベント
 * が即座に受理される。defineしない場合には、割り込み待ち状態で
 * ハードウェア・エラー・割り込みが発生した場合、次の割り込みまで
 * 待たされることになる。
 *
 */
//#define QUICK_HW_ERROR


/*
 * 実行時初期化関数の使用
 *
 * マクロ USE_RUNTIME_INIT を定義すると、start.asmのなかで _mi_initialize
 * を呼び出す。この関数はノーブートモードで起動するときにのみ必要になるので
 * 通常は USE_RUNTIME_INITを使う必要はない。
 * 詳細はADIのEE239に詳しい。http://tinyurl.com/2hpbk (tinyURL)
 *
*/
//#define USE_RUNTIME_INIT

/*
 * カーネル管理外割り込みの宣言
 *
 * マクロUNMANAGED_INTはカーネル管理外割り込みを宣言する。この
 * マクロは16ビットのビットマップになっており、以下にあるパターン
 * のうちひとつを使う。なお、どのようなパターンを選んでもNMIは管理外
 * 割込みとして扱われる。
 * UNMANAGED_INTを宣言しない場合、NMIだけが管理外割込みとして扱われる。
 *
*/
//#define UNMANAGED_INT 0x0020          // IVHWがカーネル管理外.
//#define UNMANAGED_INT 0x0060          // IVTMRとIVHWがカーネル管理外.
//#define UNMANAGED_INT 0x00E0          // IVG7, IVTMRとIVHWがカーネル管理外.
//#define UNMANAGED_INT 0x01E0          // IVG8 ... IVG7, IVTMRとIVHWがカーネル管理外.
//#define UNMANAGED_INT 0x03E0          // IVG9 ... IVG7, IVTMRとIVHWがカーネル管理外.
//#define UNMANAGED_INT 0x07E0          // IVG10 ... IVG7, IVTMRとIVHWがカーネル管理外.
//#define UNMANAGED_INT 0x0FE0          // IVG11 ... IVG7, IVTMRとIVHWがカーネル管理外.
//#define UNMANAGED_INT 0x1FE0          // IVG12 ... IVG7, IVTMRとIVHWがカーネル管理外.
//#define UNMANAGED_INT 0x3FE0          // IVG13 ... IVG7, IVTMRとIVHWがカーネル管理外.

/*
 * C++関連資源を用意する
 *
 * マクロINIT_C_PLUS_PLUSを定義すると、C++言語用のテーブルを
 * 初期化コードを実行する。また、C++言語用のテーブルを宣言する
 *
*/
// #define INIT_C_PLUS_PLUS

/*
 *  起動メッセージのターゲットシステム名
 */
#define TARGET_NAME "BSP-BB-BF592-SGTL5000-NTS"


/*
 *  シリアルポート数の定義
 *  TNUM_SIOP_XXXは、UARTの種別ごとに宣言する。
 *  TNUM_SIOP_UARTはBF592内蔵UARTのうち、PDICが使用するもの。
 *  BF592はUARTをひとつしかもっていないので、1か0を宣言する。
 *  TNUM_PORTは、TNUM_SIOP_XXXのうち、GDICが使用するものの総和。
 *  uart.cで使う。
 */
#define TNUM_PORT   1       /* GDICがサポートするシリアルポートの数 */
#define TNUM_SIOP_UART  1   /* PIDCがサポートするシリアルポートの数 */

/*
 *  シリアルポート番号に関する定義
 *  ログタスクがシリアルポートを使わない場合は無視していい。
 */
#define LOGTASK_PORTID  1   /* システムログに用いるシリアルポート番号。UART0はシリアルポート1である */

/*  UART0のボーレート． */
#define UART0_BAUD_RATE 57600       /* 57600 bps*/



#endif /* _SYS_CONFIG_H_ */
