' table/RecordProvider.vb
'
' Copyright (c) 2008-2011, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Partial Class UTable

    Public Class CRecordProvider

        Public FieldDescs As New Dictionary(Of Object, CFieldDesc)
        Public Rows As New CGrids
        Public ChildRecordProvider As CRecordProvider = Nothing
        Public ColsCount As Integer = 0
        Public LastTabOrder As Integer = -1
        Public MaxRecordCount As Integer = 0
        Public LimitIncludeFocusColor As Boolean = False

        Private _Setting As UTable.CSetting = Nothing
        Private _BorderSetting As UTable.CBorderSetting = Nothing

        Public Function HasSetting() As Boolean
            Return Me._Setting IsNot Nothing
        End Function

        Public Sub ClearSetting()
            Me.Setting = Nothing
        End Sub

        Public Property Setting() As UTable.CSetting
            Get
                If Me._Setting Is Nothing Then
                    Me._Setting = New UTable.CSetting
                End If
                Return Me._Setting
            End Get
            Set(ByVal value As UTable.CSetting)
                Me._Setting = value
            End Set
        End Property

        Public Function HasBorderSetting() As Boolean
            Return Me._BorderSetting IsNot Nothing
        End Function

        Public Sub ClearBorderSetting()
            Me._BorderSetting = Nothing
        End Sub

        Public Property BorderSetting() As UTable.CBorderSetting
            Get
                If Me._BorderSetting Is Nothing Then
                    Me._BorderSetting = New UTable.CBorderSetting
                End If
                Return Me._BorderSetting
            End Get
            Set(ByVal value As UTable.CBorderSetting)
                Me._BorderSetting = value
            End Set
        End Property

        Public Function AddField(ByVal key As Object, _
                                 ByVal provider As IFieldProvider) As CFieldDesc
            Return Me.AddField(key, provider, Nothing)
        End Function

        Public Function AddField(ByVal key As Object, _
                                 ByVal provider As IFieldProvider, _
                                 ByVal layout As CGrid.CRegion) As CFieldDesc
            Return Me._AddField(Of CFieldDesc)(key, provider, layout)
        End Function

        Protected Function _AddField(Of TDesc As {CFieldDesc, New}) _
                                    (ByVal key As Object, _
                                     ByVal provider As IFieldProvider, _
                                     ByVal layout As CGrid.CRegion) As TDesc
            Dim field As New TDesc
            field.Initialize(provider, layout)
            If layout IsNot Nothing Then
                Do While Me.Rows.Count < layout.Row + layout.Rows
                    Me.Rows.Add(New CGrid)
                Loop
                If Me.ColsCount < layout.Col + layout.Cols Then
                    Me.ColsCount = layout.Col + layout.Cols
                End If
                If provider.Focusable Then
                    Me.LastTabOrder += 1
                    provider.TabOrder = Me.LastTabOrder
                End If
            End If
            Me.FieldDescs.Add(key, field)
            Return field
        End Function

        Public Sub SetChildRecordProvider(ByVal recordProvider As CRecordProvider)
            Me.ChildRecordProvider = recordProvider
        End Sub

        Public Function Layout(ByVal key As Object) As CGrid.CRegion
            Return Me.FieldDescs(key).Layout
        End Function

        Public Function Layout(ByVal key1 As Object, ByVal key2 As Object) As CGrid.CRegion
            Return Me.FieldDescs(key1).Layout.Union(Me.FieldDescs(key2).Layout)
        End Function

        Public Sub FlatBorder(ByVal key1 As Object, ByVal key2 As Object)
            CFieldProvider.FlatBorder(Me.FieldDescs, key1, key2)
        End Sub

    End Class

End Class