package org.unitedfront2.web.handler;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.web.bind.ServletRequestBindingException;
import org.unitedfront2.domain.Terminal;
import org.unitedfront2.web.WebUtils;

public class TerminalChangeInterceptorTest {

    private TerminalChangeInterceptor interceptor;

    @Before
    public void setUp() {
        interceptor = new TerminalChangeInterceptor();
        List<String> mobileUserAgentsRegex = new ArrayList<String>();
        mobileUserAgentsRegex.add("^DoCoMo.*$");
        mobileUserAgentsRegex.add("^(UP\\.Browser\\/|KDDI-).*$");
        mobileUserAgentsRegex.add("^(J-PHONE|Vodafone|MOT|SoftBank).*$");
        interceptor.setMobileUserAgentsRegex(mobileUserAgentsRegex);
    }

    @Test
    public void testPreHandle[hNGXgĂȂꍇ͉Ȃ() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        interceptor.preHandle(request, null, null);
        Assert.assertNull("ZbV݂Ă", request.getSession(false));
    }

    @Test
    public void testPreHandle\Ȃ[hNGXgĂȂꍇ͉Ȃ() throws ServletRequestBindingException {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("terminal", "tv");
        interceptor.preHandle(request, null, null);
        Assert.assertNull("ZbV݂Ă", request.getSession(false));
    }

    @Test
    public void testPreHandleoC[hNGXgꂽꍇ̓ZbVɏi[() throws ServletRequestBindingException {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("terminal", "mobile");
        interceptor.preHandle(request, null, null);
        HttpSession session = request.getSession(false);
        Assert.assertNotNull("ZbVnull", session);
        Assert.assertEquals(Terminal.MOBILE, session.getAttribute(WebUtils.TERMINAL_PARAM_NAME));
    }

    @Test
    public void testPostHandleZbVȂԂPC̃ANZX() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
        interceptor.preHandle(request, null, null);
        Assert.assertEquals(Terminal.PC, request.getAttribute("_terminal"));
    }

    @Test
    public void testPostHandleZbVȂԂŃhR[ANZX() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("User-Agent", "DoCoMo/2.0 F901iC(c100;TB;W23H12)");
        interceptor.preHandle(request, null, null);
        Assert.assertEquals(Terminal.MOBILE, request.getAttribute("_terminal"));
    }

    @Test
    public void testPostHandleȑOPCNGXgĂPCŃANZX() {
        MockHttpSession session = new MockHttpSession();
        session.setAttribute(WebUtils.TERMINAL_PARAM_NAME, Terminal.PC);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setSession(session);
        request.addHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
        interceptor.preHandle(request, null, null);
        Assert.assertEquals(Terminal.PC, request.getAttribute("_terminal"));
    }

    @Test
    public void testPostHandleȑOPCNGXgĂhR[ŃANZX() {
        MockHttpSession session = new MockHttpSession();
        session.setAttribute(WebUtils.TERMINAL_PARAM_NAME, Terminal.PC);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setSession(session);
        request.addHeader("User-Agent", "DoCoMo/2.0 F901iC(c100;TB;W23H12)");
        interceptor.preHandle(request, null, null);
        Assert.assertEquals(Terminal.PC, request.getAttribute("_terminal"));
    }

    @Test
    public void testPostHandleȑOɃoCNGXgĂPCŃANZX() {
        MockHttpSession session = new MockHttpSession();
        session.setAttribute(WebUtils.TERMINAL_PARAM_NAME, Terminal.MOBILE);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setSession(session);
        request.addHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
        interceptor.preHandle(request, null, null);
        Assert.assertEquals(Terminal.MOBILE, request.getAttribute("_terminal"));
    }

    @Test
    public void testPostHandleȑOɃoCNGXgĂAU[ŃANZX() {
        MockHttpSession session = new MockHttpSession();
        session.setAttribute(WebUtils.TERMINAL_PARAM_NAME, Terminal.MOBILE);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setSession(session);
        request.addHeader("User-Agent", "KDDI-HI31 UP.Browser/6.2.0.5 (GUI) MMP/2.0");
        interceptor.preHandle(request, null, null);
        Assert.assertEquals(Terminal.MOBILE, request.getAttribute("_terminal"));
    }

    @Test
    public void testPostHandleZbV邪NGXg͂ĂȂԂSoftbank[̃ANZX() {
        MockHttpSession session = new MockHttpSession();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setSession(session);
        request.addHeader("User-Agent", "SoftBank/1.0/V904SH/SHJ001/SN123456789012 Browser/Browser/1.0 Profile/MIDP-2.0 Configuration/CLDC-1.1");
        interceptor.preHandle(request, null, null);
        Assert.assertEquals(Terminal.MOBILE, request.getAttribute("_terminal"));
        Assert.assertEquals(Terminal.MOBILE, session.getAttribute(WebUtils.TERMINAL_PARAM_NAME));
    }

    @Test
    public void testPostHandleZbV邪NGXg͂ĂȂԂPC̃ANZX() {
        MockHttpSession session = new MockHttpSession();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setSession(session);
        request.addHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
        interceptor.preHandle(request, null, null);
        Assert.assertEquals(Terminal.PC, request.getAttribute("_terminal"));
        Assert.assertEquals(Terminal.PC, session.getAttribute(WebUtils.TERMINAL_PARAM_NAME));
    }
}
