package org.unitedfront2.validation;

import java.util.ArrayList;
import java.util.Collection;

import org.junit.Test;

public class ValidateTest {

    @Test
    public void testLengthInRange󕶎() {
        Validate.lengthInRange("", 0, 8);
    }

    @Test(expected=ValidationException.class)
    public void testLengthInRangep̕() {
        Validate.lengthInRange("test", 5, 8);
    }

    @Test
    public void testLengthInRangep̕ŏ() {
        Validate.lengthInRange("testa", 5, 8);
    }

    @Test
    public void testLengthInRangep̕ő() {
        Validate.lengthInRange("testaaaa", 5, 8);
    }

    @Test(expected=ValidationException.class)
    public void testLengthInRangep̕傫() {
        Validate.lengthInRange("testaaaaa", 5, 8);
    }

    @Test(expected=ValidationException.class)
    public void testLengthInRangeSp̕() {
        Validate.lengthInRange("", 5, 8);
    }

    @Test
    public void testLengthInRangeSp̕ŏ() {
        Validate.lengthInRange("", 5, 8);
    }

    @Test
    public void testLengthInRangeSp̕ő() {
        Validate.lengthInRange("", 5, 8);
    }

    @Test(expected=ValidationException.class)
    public void testLengthInRangeSp̕傫() {
        Validate.lengthInRange("", 5, 8);
    }

    @Test(expected=ValidationException.class)
    public void testMailAddrNull() {
        Validate.mailAddr(null);
    }

    @Test(expected=ValidationException.class)
    public void testMailAddr󕶎() {
        Validate.mailAddr("");
    }

    @Test(expected=ValidationException.class)
    public void testMailAddr󔒂܂܂Ă() {
        Validate.mailAddr("tester @example.com");
    }

    @Test(expected=ValidationException.class)
    public void testMailAddrPȂ镶() {
        Validate.mailAddr("abcdefg");
    }

    @Test(expected=ValidationException.class)
    public void testMailAddr{̃[AhX() {
        Validate.mailAddr("eX^[@example.com");
    }

    @Test
    public void testMailAddr[AhX() {
        Validate.mailAddr("tester@example.com");
    }

    @Test
    public void testMatchl󕶎() {
        Validate.match("", "[a-z]*");
    }

    @Test(expected=ValidationException.class)
    public void testMatchK\󕶎() {
        Validate.match("tester", "");
    }

    @Test(expected=ValidationException.class)
    public void testMatchK\Ƀ}b`Ȃ() {
        Validate.match("1234", "[a-z]*");
    }

    @Test
    public void testMatchK\Ƀ}b`() {
        Validate.match("tester", "[a-z]*");
    }

    @Test
    public void testMaxLength󕶎() {
        Validate.maxLength("", 5);
    }

    @Test(expected=ValidationException.class)
    public void testMaxLengthp傫() {
        Validate.maxLength("tester", 5);
    }

    @Test
    public void testMaxLengthp̍ő() {
        Validate.maxLength("teste", 5);
    }

    @Test(expected=ValidationException.class)
    public void testMaxLengthSp傫() {
        Validate.maxLength("eX^[PQ", 5);
    }

    @Test
    public void testMaxLengthSp̍ő() {
        Validate.maxLength("eX^[P", 5);
    }

    @Test
    public void testNotAroundSpaces󕶎() {
        Validate.notAroundSpaces("");
    }

    @Test(expected=ValidationException.class)
    public void testNotAroundSpacesړɔp() {
        Validate.notAroundSpaces(" sample");
    }

    @Test(expected=ValidationException.class)
    public void testNotAroundSpacesڔɔp() {
        Validate.notAroundSpaces("sample ");
    }

    @Test(expected=ValidationException.class)
    public void testNotAroundSpacesړɑSp() {
        Validate.notAroundSpaces("@Tv");
    }

    @Test(expected=ValidationException.class)
    public void testNotAroundSpacesڔɑSp() {
        Validate.notAroundSpaces("Tv@");
    }

    @Test(expected=ValidationException.class)
    public void testNotAroundSpaces[ɔp() {
        Validate.notAroundSpaces(" sample ");
    }

    @Test(expected=ValidationException.class)
    public void testNotAroundSpaces[ɑSp() {
        Validate.notAroundSpaces("@Tv@");
    }

    @Test(expected=ValidationException.class)
    public void testNotAroundSpacesړɔp󔒂ڔɑSp() {
        Validate.notAroundSpaces(" samv@");
    }

    @Test(expected=ValidationException.class)
    public void testNotAroundSpacesڔɑSp󔒂ڔɔp() {
        Validate.notAroundSpaces("@Tple ");
    }

    @Test
    public void testNotAroundSpaces() {
        Validate.notAroundSpaces("Tv");
    }

    @Test(expected=ValidationException.class)
    public void testNotEmpty󕶎() {
        Validate.notEmpty("");
    }

    @Test
    public void testNotEmptyp() {
        Validate.notEmpty(" ");
    }

    @Test
    public void testNotEmptySp() {
        Validate.notEmpty("@");
    }

    @Test
    public void testNotEmptys() {
        Validate.notEmpty("\n");
    }

    @Test
    public void testNotEmpty^u() {
        Validate.notEmpty("\t");
    }

    @Test
    public void testNotEmpty() {
        Validate.notEmpty("Tv");
    }

    @Test(expected=ValidationException.class)
    public void testNotEmpty̔z() {
        Validate.notEmpty(new Object[0]);
    }

    @Test
    public void testNotEmptylێz() {
        Validate.notEmpty(new Object[1]);
    }

    @Test(expected=ValidationException.class)
    public void testNotEmptỹRNV() {
        Validate.notEmpty(new ArrayList<Object>(0));
    }

    @Test
    public void testNotEmptylێRNV() {
        Collection<Object> c = new ArrayList<Object>();
        c.add(new Object());
        Validate.notEmpty(c);
    }

    @Test(expected=ValidationException.class)
    public void testNotBlanknull() {
        Validate.notBlank(null);
    }

    @Test(expected=ValidationException.class)
    public void testNotBlank󕶎() {
        Validate.notBlank("");
    }

    @Test(expected=ValidationException.class)
    public void testNotBlankp() {
        Validate.notBlank(" ");
    }

    @Test(expected=ValidationException.class)
    public void testNotBlankSp() {
        Validate.notBlank("@");
    }

    @Test(expected=ValidationException.class)
    public void testNotBlanks() {
        Validate.notBlank("\n");
    }

    @Test(expected=ValidationException.class)
    public void testNotBlank^u() {
        Validate.notBlank("\t");
    }

    @Test(expected=ValidationException.class)
    public void testNotBlankʏ핶ȊO() {
        Validate.notBlank(" @\n\r\t");
    }

    @Test
    public void testNotBlank() {
        Validate.notBlank("Tv");
    }

    @Test(expected=ValidationException.class)
    public void testNotNullNull() {
        Validate.notNull(null);
    }

    @Test
    public void testNotNull󕶎() {
        Validate.notNull("");
    }

    @Test
    public void testNotNullʏ핶() {
        Validate.notNull("Tv");
    }

    @Test(expected=ValidationException.class)
    public void testNumberNull() {
        Validate.number(null);
    }

    @Test(expected=ValidationException.class)
    public void testNumberlłȂ() {
        Validate.number("aaa");
    }

    @Test
    public void testNumberl() {
        Validate.number("123");
    }
}
