package org.unitedfront2.test;

import org.junit.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.Installer;
import org.unitedfront2.domain.MailAddrUsedByOtherException;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.SimpleUserTable;
import org.unitedfront2.domain.UserCodeUsedByOtherException;
import org.unitedfront2.domain.UserNameUsedByOtherException;
import org.unitedfront2.domain.Account.Role;
import org.unitedfront2.domain.Account.Status;

/**
 * ̃eXgpf[^OɐgUNV𔺂eXgP[XłB
 *
 * @author kurokkie
 *
 */
public abstract class TransactionalTestCaseWithInitialData
    extends TransactionalTestCase {

    /** ftHg̔spX[h̍ŏ (4) */
    public static final int DEFAULT_PASSWORD_MIN_LENGTH = 4;

    /** ftHg̔spX[h̍ő啶 (8) */
    public static final int DEFAULT_PASSWORD_MAX_LENGTH = 8;

    /** AJEg 1 */
    protected Account account1;

    /** [U 1 */
    protected SimpleUser simpleUser1;

    /** AJEg 2 */
    protected Account account2;

    /** [U 2 */
    protected SimpleUser simpleUser2;

    /** AJEg 3 */
    protected Account account3;

    /** [U 3 */
    protected SimpleUser simpleUser3;

    /** [Ue[uW[ */
    @Autowired private SimpleUserTable simpleUserTable;

    /** AvP[VReLXg */
    @Autowired private ApplicationContext applicationContext;

    @Before
    public void onSetUpInTransaction() throws Exception {
        account1 = new Account("tester1@unitedfront2.org", "password",
                Status.AVAILABLE, Role.ROLE_USER);
        account1.encrypt();
        account1 = domainFactory.prototype(account1, Account.class);
        simpleUser1 = domainFactory.prototype(new SimpleUser(null, "tester1",
                "eX^[1"), SimpleUser.class);
        register(account1, simpleUser1);

        account2 = new Account("tester2@unitedfront2.org", "password",
                Status.AVAILABLE, Role.ROLE_USER);
        account2.encrypt();
        account2 = domainFactory.prototype(account2, Account.class);
        simpleUser2 = domainFactory.prototype(new SimpleUser(null, "tester2",
                "eX^[2"), SimpleUser.class);
        register(account2, simpleUser2);

        account3 = new Account("tester3@unitedfront2.org", "password",
                Status.AVAILABLE, Role.ROLE_USER);
        account3.encrypt();
        account3 = domainFactory.prototype(account3, Account.class);
        simpleUser3 = domainFactory.prototype(new SimpleUser(null, "tester3",
                "eX^[3"), SimpleUser.class);
        register(account3, simpleUser3);
    }

    private void register(Account account, SimpleUser user)
        throws MailAddrUsedByOtherException, UserCodeUsedByOtherException,
        UserNameUsedByOtherException {

        String plainPassword = Account.createRandomPassword(
                DEFAULT_PASSWORD_MIN_LENGTH, DEFAULT_PASSWORD_MAX_LENGTH);
        account.setPlainPassword(plainPassword);
        account.addRole(Account.Role.ROLE_USER);
        account.setStatus(Account.Status.AVAILABLE);
        account.encrypt();
        account.store();

        user.setId(account.getId());
        simpleUserTable.install(user);
    }

    protected void install() {
        for (Object o
                : applicationContext.getBeansOfType(Installer.class).values()) {
            Installer i = (Installer) o;
            i.install(simpleUser1.getId());
            i.install(simpleUser2.getId());
            i.install(simpleUser3.getId());
        }
    }
}
