package org.unitedfront2.domain.communication;

import org.junit.Assert;
import org.junit.Test;
import org.unitedfront2.domain.accesscontrol.OwnerOnly;
import org.unitedfront2.domain.accesscontrol.UserOnly;

public class SingleThreadCommunityTest extends AbstractCommunityTest {

    @Override
    protected SingleThreadCommunity createCommunity(int no) {
        SingleThreadCommunity c = domainFactory.prototype(SingleThreadCommunity.class);
        c.setCode("community-" + no);
        c.setOverview(createOverview());
        c.setOwnerId(simpleUser1.getId());
        c.setReadAccessControl(domainFactory.prototype(UserOnly.class));
        c.setWriteAccessControl(domainFactory.prototype(OwnerOnly.class));
        c.setPostAccessControl(domainFactory.prototype(UserOnly.class));
        return c;
    }

    @Override
    protected void assertAfterStore(Community community) {
        SingleThreadCommunity c = (SingleThreadCommunity) community;
        Assert.assertNotNull(c.getThread());
        Assert.assertNotNull(threadTable.find(c.getThreadId()));
    }

    @Override
    protected void assertAfterDelete(Community community) {
        SingleThreadCommunity c = (SingleThreadCommunity) community;
        Assert.assertNull(threadTable.find(c.getThreadId()));
    }

    @Test
    public void testChangeTo}`XbhR~jeB֕ύX() throws CommunityCodeUsedByOtherException, CannotChangeCommunityException {
        Community c = createCommunity(0);
        Assert.assertSame(SingleThreadCommunity.class, c.getClass());
        c.store();
        Assert.assertEquals(c, communityTable.find(c.getId()));
        c = c.changeTo(MultiThreadCommunity.class);
        Assert.assertSame(MultiThreadCommunity.class, c.getClass());
        c.store();
        Assert.assertEquals(c, communityTable.find(c.getId()));
    }

    @Test
    public void testIsDeletable폜ł() throws CommunityCodeUsedByOtherException {
        SingleThreadCommunity c = createCommunity(0);
        c.store();
        Assert.assertTrue(c.isDeletable());
    }

    @Test
    public void testIsDeletableLߍ폜łȂ() throws CommunityCodeUsedByOtherException {
        SingleThreadCommunity c = createCommunity(0);
        c.store();
        c.post(createEntry());
        Assert.assertFalse(c.isDeletable());
    }

    @Test
    public void testGetLastUpdateDateLȂꍇ͊Tv̍XVԂ() throws CommunityCodeUsedByOtherException {
        SingleThreadCommunity c = createCommunity(0);
        c.store();
        Assert.assertEquals(c.getOverview().getLastUpdateDate(), c.getLastUpdateDate());
    }

    @Test
    public void testGetLastUpdateDateLꍇ͍ŐVL̓o^Ԃ() throws CommunityCodeUsedByOtherException, InterruptedException {
        SingleThreadCommunity c = createCommunity(0);
        c.store();
        java.lang.Thread.sleep(1000);
        c.post(createEntry());
        c.retrieveEntries(0, 1);
        Assert.assertEquals(c.getEntries().get(0).getLastUpdateDate(), c.getLastUpdateDate());
    }

    @Test
    public void testGetThread() throws CommunityCodeUsedByOtherException {
        SingleThreadCommunity c = createCommunity(0);
        c.store();
        Assert.assertNotNull(c.getThread());
    }

    @Test
    public void testGetThreadArgsThreadIdnullw肳ꂽꍇgetThreadƓ() throws CommunityCodeUsedByOtherException {
        SingleThreadCommunity c = createCommunity(0);
        c.store();
        Thread actual = c.getThread(null);
        Assert.assertEquals(actual, c.getThread());
    }

    @Test
    public void testFindThread֘AȂXbh͌Ȃ() throws CommunityCodeUsedByOtherException {
        SingleThreadCommunity c = createCommunity(0);
        c.store();
        Thread t = createThread();
        t.store();
        Thread actual = c.findThread(t.getId());
        Assert.assertNull(actual);
    }
}
