package org.unitedfront2.domain.communication;

import java.util.ArrayList;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.test.TransactionalTestCaseWithInitialData;

public class MailTableTest extends TransactionalTestCaseWithInitialData {

    @Autowired private MailTable mailTable;

    @Test
    public void testFindThread() {
        Mail mail = domainFactory.prototype(new Mail(simpleUser1.getId(), simpleUser2.getId(), "Subject", "This is a body."), Mail.class);
        mail.send();

        Mail found = mailTable.findThread(mail.getId());
        Assert.assertEquals(mail, found);
    }

    @Test
    public void testFindThreadȂ() {
        Assert.assertNull(mailTable.findThread(-1));
    }

    @Test
    public void testFindThreadByCode() {
        Mail mail = domainFactory.prototype(new Mail(simpleUser1.getId(), simpleUser2.getId(), "Subject", "This is a body."), Mail.class);
        mail.send();

        Mail found = mailTable.findThreadByCode(mail.getCode());
        Assert.assertEquals(mail, found);
    }

    @Test
    public void testFindThreadByCodeȂ() {
        Assert.assertNull(mailTable.findThreadByCode(""));
    }
}
