package org.unitedfront2.domain.communication;

import org.junit.Assert;
import org.junit.Test;
import org.unitedfront2.test.TransactionalTestCaseWithInitialData;

public class CommentTest extends TransactionalTestCaseWithInitialData {

    @Test
    public void testGetCommenter[U() {
        Comment comment = domainFactory.prototype(new Comment(simpleUser1.getId(), "Rg̃eXg"), Comment.class);
        comment.store();
        Assert.assertEquals(simpleUser1, comment.getCommenter());
    }

    @Test
    public void testGetCommenter() {
        Comment comment = domainFactory.prototype(new Comment(null, "Rg̃eXg"), Comment.class);
        comment.store();
        Assert.assertNull(comment.getCommenter());
    }
}
