package org.unitedfront2.domain.communication;

import java.util.Locale;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.accesscontrol.FriendOnly;
import org.unitedfront2.domain.accesscontrol.OwnerOnly;
import org.unitedfront2.domain.accesscontrol.Public;
import org.unitedfront2.domain.accesscontrol.UserOnly;
import org.unitedfront2.domain.communication.Thread.Status;
import org.unitedfront2.test.TransactionalTestCaseWithInitialData;

public abstract class AbstractCommunityTest extends TransactionalTestCaseWithInitialData {

    @Autowired protected ThreadTable threadTable;

    @Autowired protected CommunityTable communityTable;

    @Test
    public void testStoreo^() throws CommunityCodeUsedByOtherException {
        Community c = createCommunity(0);
        c.store();
        Community actual = communityTable.find(c.getId());
        Assert.assertEquals(c, actual);
        Assert.assertTrue(communityTable.findMyCommunities(simpleUser1.getId()).contains(c));
        assertAfterStore(c);
    }

    @Test(expected = CommunityCodeUsedByOtherException.class)
    public void testStoreo^݂邪R[hd() throws CommunityCodeUsedByOtherException {
        Community c1 = createCommunity(1);
        c1.store();
        Community c2 = createCommunity(1);
        c2.store();
    }

    @Test
    public void testStoreXV() throws CommunityCodeUsedByOtherException, CannotEntryCommunityException {
        install();

        Community c = createCommunity(0);
        c.store();
        c.entry(simpleUser2.getId());

        Assert.assertTrue(communityTable.findMyCommunities(simpleUser1.getId()).contains(c));
        Assert.assertTrue(communityTable.findMyCommunities(simpleUser2.getId()).contains(c));
        c.setCode("new_" + c.getCode());
        c.getOverview().setSubject("XṼTuWFNg", Locale.JAPANESE);
        c.getOverview().setSubject("This is a subject.", Locale.ENGLISH);
        c.getReadAccessControl().changeTo(FriendOnly.class);
        c.store();
        Community actual = communityTable.find(c.getId());
        Assert.assertEquals(c, actual);
        Assert.assertTrue(communityTable.findMyCommunities(simpleUser1.getId()).contains(c));
        Assert.assertFalse(communityTable.findMyCommunities(simpleUser2.getId()).contains(c));
        assertAfterStore(c);
    }

    @Test(expected = CommunityCodeUsedByOtherException.class)
    public void testStoreXV݂邪R[hd() throws CommunityCodeUsedByOtherException {
        Community c1 = createCommunity(1);
        c1.store();
        Community c2 = createCommunity(2);
        c2.store();
        c2.setCode(c1.getCode());
        c2.store();
    }

    protected void assertAfterStore(Community community) {
        // do nothing
    }

    @Test
    public void testDelete() throws CommunityCodeUsedByOtherException, CannotDeleteCommunityException {
        Community c = createCommunity(0);
        c.store();
        Assert.assertNotNull(communityTable.find(c.getId()));
        c.delete();
        Assert.assertNull(communityTable.find(c.getId()));
        assertAfterDelete(c);
    }

    protected void assertAfterDelete(Community community) {
        // do nothing
    }

    @Test
    public void testEntryQł() throws CommunityCodeUsedByOtherException, CannotEntryCommunityException {
        Community c = createCommunity(0);
        c.store();
        c.entry(simpleUser2.getId());
        Assert.assertTrue(communityTable.findMyCommunities(simpleUser2.getId()).contains(c));
    }

    @Test(expected = CannotEntryCommunityException.class)
    public void testEntryQ̂ߎQłȂ() throws CommunityCodeUsedByOtherException, CannotEntryCommunityException {
        Community c = createCommunity(0);
        c.store();
        c.entry(simpleUser2.getId());
        c.entry(simpleUser2.getId());
    }

    @Test
    public void testCancelމł() throws CommunityCodeUsedByOtherException, CannotEntryCommunityException, CannotCancelCommunityException {
        Community c = createCommunity(0);
        c.store();
        c.entry(simpleUser2.getId());
        Assert.assertTrue(communityTable.findMyCommunities(simpleUser2.getId()).contains(c));
        c.cancel(simpleUser2.getId());
        Assert.assertFalse(communityTable.findMyCommunities(simpleUser2.getId()).contains(c));        
    }

    @Test(expected = CannotCancelCommunityException.class)
    public void testCancelL҂͑މłȂ() throws CommunityCodeUsedByOtherException, CannotEntryCommunityException, CannotCancelCommunityException {
        Community c = createCommunity(0);
        c.store();
        c.cancel(simpleUser1.getId());
    }

    @Test(expected = CannotCancelCommunityException.class)
    public void testCancelłȂ̂ɑމłȂ() throws CommunityCodeUsedByOtherException, CannotEntryCommunityException, CannotCancelCommunityException {
        Community c = createCommunity(0);
        c.store();
        c.cancel(simpleUser2.getId());
    }

    @Test
    public void testIsMyCommunitỹR~jeB() throws CommunityCodeUsedByOtherException {
        Community c = createCommunity(0);
        c.store();
        Assert.assertTrue(c.isMyCommunity(simpleUser1));
    }

    @Test
    public void testIsMyCommunitỹR~jeBłȂ() throws CommunityCodeUsedByOtherException {
        Community c = createCommunity(0);
        c.store();
        Assert.assertFalse(c.isMyCommunity(simpleUser2));
    }

    protected abstract Community createCommunity(int no);

    protected Message createOverview() {
        Message o = domainFactory.prototype(Message.class);
        o.setSubject("eXgR~jeB", Locale.JAPANESE);
        o.setBody("̓eXgR~jeBłB", Locale.JAPANESE);
        return o;
    }

    protected Message createEntry() {
        Message e = domainFactory.prototype(Message.class);
        e.setAuthorId(simpleUser2.getId());
        e.setSubject("eXgL", Locale.JAPANESE);
        e.setBody("̓eXgLłB", Locale.JAPANESE);
        return e;
    }

    protected Thread createThread() {
        Message o = domainFactory.prototype(Message.class);
        o.setSubject("eXgXbh", Locale.JAPANESE);
        o.setBody("̓eXgXbhłB", Locale.JAPANESE);
        return domainFactory.prototype(new Thread(o, Status.AVAILABLE,
                simpleUser1.getId(), domainFactory.prototype(Public.class),
                domainFactory.prototype(OwnerOnly.class),
                domainFactory.prototype(UserOnly.class)), Thread.class);
    }
}
