package org.unitedfront2.domain.accesscontrol;

import org.junit.Assert;
import org.junit.Test;
import org.unitedfront2.domain.communication.Message;

public class AbstractCopyRightedResourceTest extends AbstractResourceTest {

    private AbstractCopyrightedResource resource;

    @Override
    public void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        Message message = domainFactory.prototype(new Message(null, null,
                simpleUser1.getId(), simpleUser2.getId(),
                domainFactory.prototype(Public.class),
                domainFactory.prototype(Public.class)), Message.class);
        message.store();
        this.resource = message;
    }

    @Test
    public void testGetAuthor() {
        Assert.assertNotNull(resource.getAuthorId());
        Assert.assertNotNull(simpleUserTable.find(resource.getAuthorId()));
        Assert.assertEquals(simpleUserTable.find(resource.getAuthorId()), resource.getAuthor());
    }
}
