<%@ page language="java" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/view/Include.jsp" %>
<div>
  <h2><spring:message code="community.Index"/></h2>
  <div class="align-right">
    <a href="<c:url value="/community/create.html"/>"><spring:message code="community.createLink"/></a>
  </div>
  <ul class="noneMarker">
    <c:forEach var="c" items="${communities}">
      <li>
        <div class="float-left">
          <span class="smaller thin"><uf2:formatDate date="${c.lastUpdateDate}" detail="true"/></span>
          <a href="<c:url value="/community/${c.code}/index.html"/>"><uf2:messageSubject message="${c.overview}"/></a>
        </div>
        <c:if test="${c.ownerId != _user.id}">
          <form action="<c:url value="/community/cancel.html"/>" method="post" onsubmit="return confirm('<spring:escapeBody javaScriptEscape="true"><spring:message code="community.View.cancelConfirm" arguments="${c.overview.subject}"/></spring:escapeBody>');" class="float-right">
            <input type="hidden" name="code" value="${c.code}"/>
            <input type="submit" name="" value="<spring:message code="community.View.cancelLink"/>" class="smaller"/>
          </form>
        </c:if>
        <div class="float-clear"></div>
      </li>
    </c:forEach>
  </ul>
  <div class="align-center margin-top">
    <a href="<c:url value="/community/indexAll.html"/>"><spring:message code="community.findAllLink"/></a>
  </div>
</div>
