package org.unitedfront2.web.validator;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.validation.ValidationContext;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.AccountTable;
import org.unitedfront2.validation.ValidationException;

/**
 * {@link Account} p̃of[^NXłB
 *
 * @author kurokkie
 *
 */
public class AccountValidator extends org.unitedfront2.domain.AccountValidator {

    /** VAԍ */
    private static final long serialVersionUID = -5901931335480947456L;

    public void validateMailAddrForm(Account account,
            ValidationContext context) {
        try {
            validateMailAddr(account, true);
        } catch (ValidationException e) {
            context.getMessageContext().addMessage(new MessageBuilder().error()
                    .source("mailAddr").code(e.getCode()).args(e.getArguments())
                    .build());
        }
    }

    public void validatePasswordForm(Account account,
            ValidationContext context) {
        try {
            validatePassword(account);
        } catch (ValidationException e) {
            context.getMessageContext().addMessage(new MessageBuilder().error()
                    .source("password").code(e.getCode()).args(e.getArguments())
                    .build());
        }
    }

    @Override
    @Autowired
    public void setAccountTable(AccountTable accountTable) {
        super.setAccountTable(accountTable);
    }
}
