package org.unitedfront2.web.security;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.AccountTable;
import org.unitedfront2.util.PropertyUtils;

/**
 * Acegi Security {@link UserDetailsService} ̎łB
 *
 * @author kurokkie
 *
 */
public class UserDetailsServiceImpl implements UserDetailsService {

    /**
     * Acegi Security ̔F؏ŗp\ȃAJEgNXłB
     *
     * @author kurokkie
     *
     */
    private static class AcegiAccount extends Account implements UserDetails {

        /** VAԍ */
        private static final long serialVersionUID = 4389934408623924658L;

        public AcegiAccount() {
            super();
        }

        public AcegiAccount(Account account) {
            super();
            PropertyUtils.copyProperties(this, account);
            account.copyPasswordTo(this);
        }

        /**
         *  {@link GrantedAuthority} ̔zɕϊĕԂ܂B
         * @return {@link GrantedAuthority}@̔z
         */
        @Override
        public GrantedAuthority[] getAuthorities() {
            GrantedAuthority[] grantedAuthorities
                = new GrantedAuthority[getRoles().size()];
            int i = 0;
            for (Role role : getRoles()) {
                grantedAuthorities[i]
                    = new GrantedAuthorityImpl(role.toString());
                i++;
            }
            return grantedAuthorities;
        }

        /**
         * [AhXԂ܂B
         * @return [AhX
         */
        @Override
        public String getUsername() {
            return getMailAddr();
        }

        @Override
        public boolean isAccountNonExpired() {
            return getStatus() != Status.EXPIRED;
        }

        @Override
        public boolean isAccountNonLocked() {
            return getStatus() != Status.LOCKED;
        }

        @Override
        public boolean isCredentialsNonExpired() {
            return getStatus() != Status.CREDENTIALS_EXPIRED;
        }

        @Override
        public boolean isEnabled() {
            return getStatus() == Status.AVAILABLE;
        }
    }

    /** O */
    protected final Log logger = LogFactory.getLog(getClass());

    /** AJEge[u */
    @Autowired private AccountTable accountTable;

    /**
     * p҂̏ڍׂ擾܂B
     *
     * @param mailAddr [AhX
     * @return Acegi AJEg
     * @throws UsernameNotFoundException p҂݂Ȃ
     */
    @Override
    public UserDetails loadUserByUsername(String mailAddr)
        throws UsernameNotFoundException {

        Account account = accountTable.findByMailAddr(mailAddr);
        if (account == null) {
            String message = "The mail address '" + mailAddr + "' not found.";
            if (logger.isWarnEnabled()) {
                logger.warn(message);
            }
            throw new UsernameNotFoundException(message);
        }
        return new AcegiAccount(account);
    }
}
