package org.unitedfront2.web.handler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.SimpleUserTable;
import org.unitedfront2.domain.User;
import org.unitedfront2.web.WebUtils;

/**
 * ZbṼ[Ur[ŗpł悤ɂ܂BŏIANZXōXV܂B
 *
 * @author kurokkie
 */
@Repository(value = "userInterceptor")
public class UserInterceptor extends HandlerInterceptorAdapter {

    /** O */
    protected final Log logger = LogFactory.getLog(getClass());

    /** [Ue[u */
    @Autowired private SimpleUserTable simpleUserTable;

    @Override
    public boolean preHandle(HttpServletRequest request,
            HttpServletResponse response, Object handler) throws Exception {

        HttpSession session = request.getSession(false);

        if (session == null) {
            return true;
        }

        Account account = WebUtils.findAccount(session);

        if (account == null) {
            return true;
        }

        request.setAttribute(WebUtils.ACCOUNT_PARAM_NAME, account);

        SimpleUser user = WebUtils.findUser(session);

        if (user == null) {
            user = simpleUserTable.find(account.getId());
            WebUtils.setUser(session, (User) user);
        }

        request.setAttribute(WebUtils.USER_PARAM_NAME, user);

        try {
            user.touch();
        } catch (IllegalStateException e) {
            if (logger.isDebugEnabled()) {
                logger.warn(e);
            } else if (logger.isWarnEnabled()) {
                logger.warn(e.getMessage());
            }
            try {
                user = simpleUserTable.find(account.getId());
            } catch (IllegalArgumentException ea) {
                // ZbVɕsȃ[Uf[^cĂꍇɋN
                logger.error(ea.getMessage(), ea);
                return true;
            }
            WebUtils.setUser(session, (User) user);
        }

        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request,
            HttpServletResponse response, Object handler,
            ModelAndView modelAndView) throws Exception {
        request.setAttribute(WebUtils.ACCOUNT_PARAM_NAME,
                WebUtils.findAccount(request.getSession(false)));
        request.setAttribute(WebUtils.USER_PARAM_NAME,
                WebUtils.findUser(request.getSession(false)));
    }
}
