package org.unitedfront2.web.controller.thread;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.DomainFactory;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.MessageCodeUsedByOtherException;
import org.unitedfront2.domain.communication.MessageTable;
import org.unitedfront2.domain.communication.Thread;
import org.unitedfront2.domain.communication.Thread.Status;
import org.unitedfront2.domain.communication.ThreadTable;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.controller.SubflowUtils;
import org.unitedfront2.web.controller.message.FormAction;
import org.unitedfront2.web.flow.AccessDeniedException;
import org.unitedfront2.web.flow.BadRequestException;
import org.unitedfront2.web.flow.PageNotFoundException;

/**
 * Le/XVANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "threadEntryFormAction")
public class EntryFormAction extends MultiAction {

    /** Xbh ID ̕ϐ (threadId) */
    public static final String THREAD_ID_PARAM_NAME = "threadId";

    /** bZ[WR[h̕ϐ (messageCode) */
    public static final String MESSAGE_CODE_PARAM_NAME = "messageCode";

    /** hCt@Ng */
    @Autowired
    private DomainFactory domainFactory;

    /** Xbhe[u */
    @Autowired
    private ThreadTable threadTable;

    /** bZ[We[u */
    @Autowired
    private MessageTable messageTable;

    /**
     * ANZX̌؂ƃbZ[WtH[Tut[ւ̐ݒs܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     * @throws BadRequestException ID s
     * @throws AccessDeniedException ANZX
     */
    public Event init(RequestContext context) throws BadRequestException,
        AccessDeniedException {
        int threadId = context.getFlowScope().getRequiredInteger(
                THREAD_ID_PARAM_NAME);
        Thread t = getThreadAndValidate(context, threadId);

        // Xbh̊J`FbN
        if (t.getStatus() == Status.LOCKED) {
            String message = "The thread " + t.getId()
                + " has already been closed.";
            logger.warn(message);
            throw new BadRequestException(context, this, message);
        }

        Message entry = getEntryAndValidate(context);
        if (entry == null) {
            context.getFlowScope().put(
                    SubflowUtils.PAGE_TITLE_CODE_PARAM_NAME,
                    "thread.EntryCreateForm");
            context.getFlowScope().put(
                    SubflowUtils.PAGE_DESCRIPTION_CODE_PARAM_NAME,
                    "thread.EntryCreateForm.description");
            context.getFlowScope().put(SubflowUtils.FORM_SUBMIT_CODE_PARAM_NAME,
                "doPost");
        } else {
            context.getFlowScope().put(
                    SubflowUtils.PAGE_TITLE_CODE_PARAM_NAME,
                    "thread.EntryUpdateForm");
            context.getFlowScope().put(
                    SubflowUtils.PAGE_DESCRIPTION_CODE_PARAM_NAME,
                    "thread.EntryUpdateForm.description");
            context.getFlowScope().put(SubflowUtils.FORM_SUBMIT_CODE_PARAM_NAME,
                "doUpdate");
        }
        return success();
    }

    /**
     * L𓊍e܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     * @throws PageNotFoundException w肵uOȂ
     */
    public Event store(RequestContext context) throws PageNotFoundException {
        // x
        Message entry = WebUtils.getDomain(context.getFlowScope(),
                FormAction.MESSAGE_PARAM_NAME, Message.class, domainFactory);

        int threadId = context.getFlowScope().getRequiredInteger(
                THREAD_ID_PARAM_NAME);
        Thread t = getThreadAndValidate(context, threadId);

        User u = WebUtils.findUser(context);
        if (u != null) {
            entry.setAuthorId(u.getId());
        }
        if (entry.getId() == null) {
            // VKe
            t.post(entry);
        } else {
            // XV
            try {
                entry.store();
            } catch (MessageCodeUsedByOtherException e) {
                // N肦Ȃ
                logger.error(e.getMessage(), e);
                throw new IllegalStateException(e);
            }
        }

        return success();
    }

    private Thread getThreadAndValidate(RequestContext context, int threadId)
        throws BadRequestException, AccessDeniedException {
        Thread t = threadTable.find(threadId);
        if (t == null) {
            String message = "The thread ID '" + threadId + "' not found.";
            logger.warn(message);
            throw new BadRequestException(context, this, message);
        }
        User u = WebUtils.findUser(context);
        try {
            t.postAccess(u);
        } catch (
                org.unitedfront2.domain.accesscontrol.AccessDeniedException e) {
            logger.warn(e.getMessage(), e);
            throw new AccessDeniedException(context, this, e);
        }
        return t;
    }

    private Message getEntryAndValidate(RequestContext context)
        throws BadRequestException, AccessDeniedException {
        String code = context.getFlowScope().getString(MESSAGE_CODE_PARAM_NAME);
        if (code == null) {
            // VKe
            return null;
        }

        // ҏW
        Message entry = messageTable.findByCode(code);
        if (entry == null) {
            String message = "The message code '" + code + "' not found.";
            logger.warn(message);
            throw new BadRequestException(context, this, message);
        }

        User u = WebUtils.findUser(context);
        if (u == null) {
            // [U͕ҏWłȂ
            String message
                = "The anonymous user cannot update any entries.";
            logger.warn(message);
            throw new AccessDeniedException(context, this, message);
        }
        try {
            entry.writeAccess(u.getId());
        } catch (
                org.unitedfront2.domain.accesscontrol.AccessDeniedException e) {
            logger.warn(e.getMessage(), e);
            throw new AccessDeniedException(context, this, e);
        }
        return entry;
    }
}
