package org.unitedfront2.web.controller.profile;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.DomainFactory;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.MessageCodeUsedByOtherException;
import org.unitedfront2.domain.communication.Profile;
import org.unitedfront2.domain.communication.ProfileTable;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.controller.SubflowUtils;
import org.unitedfront2.web.controller.message.FormAction;

/**
 * ȏЉXVp̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "profileSelfIntroductionUpdateAction")
public class SelfIntroductionUpdateAction extends MultiAction {

    /** hCt@Ng */
    @Autowired
    private DomainFactory domainFactory;

    /** vtB[e[u */
    @Autowired
    private ProfileTable profileTable;

    /**
     * s̃bZ[WtH[ɐݒ肵܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event init(RequestContext context) {
        context.getFlowScope().put(SubflowUtils.PAGE_TITLE_CODE_PARAM_NAME,
                "profile.SelfIntroductionUpdateForm");
        context.getFlowScope().put(SubflowUtils.FORM_SUBMIT_CODE_PARAM_NAME,
                "doUpdate");
        return success();
    }

    /**
     * ȏЉXV܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event update(RequestContext context) {
        User user = WebUtils.getUser(context);
        Profile profile = profileTable.find(user.getId());
        Message message = WebUtils.getDomain(context.getFlowScope(),
                FormAction.MESSAGE_PARAM_NAME, Message.class, domainFactory);
        profile.getSelfIntroduction().setEntryMap(message.getEntryMap());
        try {
            profile.getSelfIntroduction().store();
        } catch (MessageCodeUsedByOtherException e) {
            logger.error(e);
            throw new IllegalStateException(e);
        }
        context.getFlowScope().put("user", user);
        return success();
    }
}
