package org.unitedfront2.web.controller.profile;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.ProfileTable;

/**
 * vtB[JĂS[UꗗANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "profilePublicProfileAction")
public class PublicProfileAction extends AbstractAction {

    /** vtB[e[u */
    @Autowired private ProfileTable profileTable;

    @Override
    protected Event doExecute(RequestContext context) throws Exception {
        context.getFlashScope().put("users",
                profileTable.getPublicProfileOwnersRandomly());
        return success();
    }
}
