package org.unitedfront2.web.controller.profile;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.SimpleUserTable;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.communication.Profile;
import org.unitedfront2.domain.communication.ProfileTable;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.flow.BadRequestException;

/**
 * FB\݂ɑ΂AFBɂȂ邱ƂANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "profileFriendAllowAction")
public class FriendAllowAction extends MultiAction {

    /** [Ue[u */
    @Autowired private SimpleUserTable simpleUserTable;

    /** vtB[e[u */
    @Autowired private ProfileTable profileTable;

    /**
     * s܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     * @throws BadRequestException p[^sAFB\݂݂Ȃ
     */
    public Event allow(RequestContext context) throws BadRequestException {
        String userCode = context.getRequestParameters().getRequired(
                "userCode");

        User user = WebUtils.getUser(context);
        try {
            allowFriendSubscription(user.getId(), userCode);
        } catch (UserNotFoundException e) {
            logger.warn(e.getMessage());
            throw new BadRequestException(context, this, e);
        } catch (FriendSubscriptionNotFoundException e) {
            logger.warn(e.getMessage());
            throw new BadRequestException(context, this, e);
        }

        context.getFlowScope().put("userCode", user.getCode());
        return success();
    }

    private void allowFriendSubscription(int userId, String toUserCode)
        throws UserNotFoundException, FriendSubscriptionNotFoundException {
        User toUser = simpleUserTable.findByCode(toUserCode);
        if (toUser == null) {
            String message = "The user [Code='" + toUserCode
                + "'] who is allowed the subscription not found.";
            logger.warn(message);
            throw new UserNotFoundException(message);
        }

        Profile profile = profileTable.findByOwnerCode(toUserCode);
        if (!profile.existFriendSubscription(userId)) {
            String message = "The friend subscription [UserId='" + userId
                + "',toUserCode='" + toUser.getCode() + "'] not found.";
            logger.warn(message);
            throw new FriendSubscriptionNotFoundException(message);
        }

        profile.allowFriendSubscription(userId);
    }
}
