package org.unitedfront2.web.controller.mail;

import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.preparer.PreparerException;
import org.apache.tiles.preparer.ViewPreparer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.communication.MailTable;
import org.unitedfront2.web.WebUtils;

/**
 * [EBWFbg {@link ViewPreparer} łB
 *
 * @author kurokkie
 *
 */
@Repository(value = "mailMailAlertWidgetPreparer")
public class MailAlertWidgetPreparer implements ViewPreparer {

    /** [e[u */
    @Autowired private MailTable mailTable;

    @Override
    public void execute(TilesRequestContext tilesContext,
            AttributeContext attributeContext) throws PreparerException {
        User user = WebUtils.findUser(tilesContext);
        if (user == null) {
            return;
        }
        int count = mailTable.countUnreadMail(user.getId());
        attributeContext.putAttribute("unreadMailCount", new Attribute(count));
    }
}
