package org.unitedfront2.web.controller.community;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.domain.communication.CommunityTable;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.view.RssView;

/**
 * }CR~jeB RSS \Rg[łB
 *
 * @author kurokkie
 *
 */
@Repository(value = "communityMyCommunitiesRssController")
public class MyCommunitiesRssController extends AbstractController {

    /** PR~jeB̋L̍ő\ (5) */
    public static final int MAX_DISPLAY_NUM = 5;

    /** R~jeBe[u */
    @Autowired
    private CommunityTable communityTable;

    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request,
            HttpServletResponse response) {

        SyndFeed feed = new SyndFeedImpl();

        // Tv
        feed.setTitle(WebUtils.getMessage("community.MyCommunities", request));
        feed.setDescription(WebUtils.getMessage(
                "community.MyCommunities.description", request));
        feed.setLink("/community/index.html");

        // L
        Locale locale = WebUtils.getLocale(request);
        List<Message> entries = getEntries(request);
        List<SyndEntry> sEntries = new ArrayList<SyndEntry>();
        for (Message m : entries) {
            SyndEntry entry = new SyndEntryImpl();
            entry.setTitle(m.getSubject(locale));
            entry.setLink(m.getUri());
            SyndContent description = new SyndContentImpl();
            description.setType("text/html");
            description.setValue(m.getBody(locale));
            entry.setDescription(description);
            entry.setPublishedDate(m.getRegistrationDate());
            entry.setUpdatedDate(m.getLastUpdateDate());
            sEntries.add(entry);
        }
        feed.setEntries(sEntries);

        ModelAndView mav = new ModelAndView(new RssView());
        mav.addObject(RssView.FEED_PARAM_NAME, feed);
        return mav;
    }

    private List<Message> getEntries(HttpServletRequest request) {
        SimpleUser u = WebUtils.getUser(request.getSession(false));
        List<Community> coms = communityTable.findMyCommunities(u.getId());
        List<Message> entries = new ArrayList<Message>();
        for (Community c : coms) {
            entries.addAll(Utils.findEntries(c, 0, MAX_DISPLAY_NUM));
        }
        Collections.sort(entries, new Comparator<Message>() {
            @Override
            public int compare(Message m1, Message m2) {
                return m2.getId().compareTo(m1.getId());
            }
        });
        return entries;
    }
}
