package org.unitedfront2.web.controller.blog;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.util.HtmlUtils;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.accesscontrol.AccessDeniedException;
import org.unitedfront2.domain.communication.Blog;
import org.unitedfront2.domain.communication.BlogEntry;
import org.unitedfront2.domain.communication.BlogTable;
import org.unitedfront2.web.PageNotFoundException;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.view.RssView;

/**
 * uO RSS \p̃Rg[łB
 *
 * @author kurokkie
 *
 */
@Repository(value = "blogRssController")
public class RssController extends AbstractController {

    /** uOL̕\ (20) */
    public static final int DISPLAY_NUM = 20;

    /** uOe[u */
    @Autowired private BlogTable blogTable;

    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request,
            HttpServletResponse response)
        throws ServletRequestBindingException, PageNotFoundException,
        org.unitedfront2.web.AccessDeniedException {
        Blog blog = getBlog(request);
        SyndFeed feed = toFeed(blog, WebUtils.getLocale(request));
        ModelAndView mav = new ModelAndView(new RssView());
        mav.addObject(RssView.FEED_PARAM_NAME, feed);
        return mav;
    }

    private Blog getBlog(HttpServletRequest request)
        throws ServletRequestBindingException, PageNotFoundException,
        org.unitedfront2.web.AccessDeniedException {
        String code = ServletRequestUtils.getRequiredStringParameter(request,
                "code");
        Blog blog = blogTable.findByCode(code);
        if (blog == null) {
            String message = "The blog [code='" + code + "'] not found.";
            logger.warn(message);
            throw new PageNotFoundException(message);
        }
        SimpleUser user = WebUtils.findUser(request.getSession(false));
        try {
            blog.readAccess(user);
        } catch (AccessDeniedException e) {
            String message = "The user '" + user
                + "' cannot access to the blog '" + blog + "'.";
            logger.warn(message);
            throw new org.unitedfront2.web.AccessDeniedException(message, e);
        }
        blog.retrieveEntries(0, DISPLAY_NUM);
        return blog;
    }

    private SyndFeed toFeed(Blog blog, Locale locale) {
        SyndFeed feed = new SyndFeedImpl();

        // Tv
        feed.setTitle(blog.getOverview().getSubject(locale));
        feed.setLink("/blog/" + blog.getCode() + "/index.html");
        feed.setDescription(blog.getOverview().getBody(locale));
        feed.setAuthor(HtmlUtils.htmlEscape(blog.getOwner().getName()));

        // L
        List<SyndEntry> entries = new ArrayList<SyndEntry>(blog.getEntries()
                .size());
        for (BlogEntry be : blog.getEntries()) {
            SyndEntry entry = new SyndEntryImpl();
            entry.setTitle(be.getEntry().getSubject(locale));
            entry.setLink("/blog/" + blog.getCode() + "/entry-"
                    + be.getCode() + ".html");
            SyndContent description = new SyndContentImpl();
            description.setType("text/html");
            description.setValue(be.getEntry().getBody(locale));
            entry.setDescription(description);
            entry.setPublishedDate(be.getEntry().getRegistrationDate());
            entry.setUpdatedDate(be.getEntry().getLastUpdateDate());
            entries.add(entry);
        }
        feed.setEntries(entries);
        return feed;
    }
}
