package org.unitedfront2.web.controller.blog;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.web.util.HtmlUtils;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.AccountTable;
import org.unitedfront2.domain.DomainFactory;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.communication.Blog;
import org.unitedfront2.domain.communication.BlogEntry;
import org.unitedfront2.domain.communication.BlogTable;
import org.unitedfront2.domain.communication.Comment;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.handler.TitleInterceptor;
import org.unitedfront2.web.mail.MailService;

/**
 * uOLƂ̃Rg̉{ƁARgeANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "blogEntryViewAction")
public class EntryViewAction extends MultiAction {

    /** hCt@Ng */
    @Autowired
    private DomainFactory domainFactory;

    /** AJEge[u */
    @Autowired
    private AccountTable accountTable;

    /** uOe[u */
    @Autowired
    private BlogTable blogTable;

    /** [MT[rX */
    @Autowired
    private MailService mailService;

    /**
     * ^Cgݒ肵܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event setTitleCode(RequestContext context) {
        BlogEntry entry = (BlogEntry) context.getFlowScope().getRequired(
                "entry", BlogEntry.class);
        context.getFlashScope().put(TitleInterceptor.TITLE_CODE_PARAM_NAME,
                "blog.EntryView");
        context.getFlashScope().put(TitleInterceptor.TITLE_ARGS_PARAM_NAME,
                new Object[] {
                    HtmlUtils.htmlEscape(entry.getEntry().getSubject(
                            WebUtils.getLocale(context))),
                });
        return success();
    }

    /**
     * Rg𓊍e܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event postComment(RequestContext context) {
        Comment comment = (Comment) context.getFlowScope()
            .getRequired("comment", Comment.class);
        comment = domainFactory.prototype(comment, Comment.class);

        // e҂̐ݒB[Ủ\
        User user = WebUtils.findUser(context);
        if (user != null) {
            comment.setCommenterId(user.getId());
        }

        BlogEntry entry = (BlogEntry) WebUtils.getDomain(context.getFlowScope(),
                "entry", domainFactory);
        entry.post(comment);

        Blog blog = (Blog) context.getFlowScope()
            .getRequired("blog", Blog.class);
        if (blogTable.isBlogCommentForwarding(blog.getOwnerId())) {
            // []L
            String commenterName;
            if (comment.getCommenter() == null) {
                // 
                commenterName = WebUtils.getMessage("anonymous", null, context);
            } else {
                commenterName = comment.getCommenter().getName();
            }

            context.getFlashScope().put("ownerAccount",
                    accountTable.find(blog.getOwnerId()));
            context.getFlashScope().put("blog", blog);
            context.getFlashScope().put("entry", entry);
            context.getFlashScope().put("comment", comment);
            context.getFlashScope().put("commenterName", commenterName);
            context.getFlashScope().put("locale",
                    WebUtils.getLocale(context));

            mailService.send("blog.BlogComment-mail",
                    context.getFlashScope().asMap(),
                    WebUtils.getLocale(context));
        }

        context.getFlowScope().put("comment", comment);
        return success();
    }
}
