package org.unitedfront2.web.controller.account;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.AccountTable;
import org.unitedfront2.domain.MailAddrAndPassword;
import org.unitedfront2.domain.MailAddrUsedByOtherException;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.flow.PageNotFoundException;
import org.unitedfront2.web.mail.MailService;

/**
 * pX[h̍ĔssANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "accountPasswordReissueAction")
public class PasswordReissueAction extends MultiAction {

    /** AJEge[u */
    @Autowired
    private AccountTable accountTable;

    /** [MT[rX */
    @Autowired
    private MailService mailService;

    /**
     * ꎞIɔsF؃L[𐶐܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event confirmPasswordReissue(RequestContext context) {
        Account command = (Account) context.getFlowScope().getRequired(
                "account", Account.class);
        Account account = accountTable.findByMailAddr(command.getMailAddr());
        if (account == null) {
            return error();
        } else {
            account.retrieveTemporaryAuthKey();
            context.getFlashScope().put("account", account);

            Map<String, Object> model = new HashMap<String, Object>();
            model.put("account", account);
            mailService.send("account.PasswordReissueConfirm-mail", model,
                    WebUtils.getLocale(context));

            return success();
        }
    }

    /**
     * pX[h̍Ĕss܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     * @throws PageNotFoundException F؃L[s
     */
    public Event reissuePassword(RequestContext context)
        throws PageNotFoundException {

        // F؃L[AJEg𕜌
        String temporaryAuthKey = context.getRequestParameters().get("key");
        if (StringUtils.isEmpty(temporaryAuthKey)) {
            String message = "The temporary auth key is null. It must be set.";
            logger.warn(message);
            throw new PageNotFoundException(context, this, message);
        }
        Account account = accountTable.findByTemporaryAuthKey(temporaryAuthKey);
        if (account == null) {
            String message = "The temporary auth key '" + temporaryAuthKey
                + "' not found.";
            if (logger.isDebugEnabled()) {
                logger.debug(message);
            }
            throw new PageNotFoundException(context, this, message);
        }

        // VpX[hs
        MailAddrAndPassword mailAddrAndPassword = reissuePassword(account);

        // [M
        Map<String, Object> model = new HashMap<String, Object>();
        model.put("mailAddrAndPassword", mailAddrAndPassword);
        mailService.send("account.PasswordReissue-mail", model,
                WebUtils.getLocale(context));

        // F؃L[폜
        account.deleteTemporaryAuthKey();

        context.getFlashScope().put("mailAddrAndPassword", mailAddrAndPassword);
        return success();
    }

    /**
     * Ǘ҂pX[h̍Ĕss܂B̓[MpłȂ
     * ɂāApX[hĔs邽߂̎iłB
     *
     * @param context NGXgReLXg
     * @return Cxg
     */
    public Event reissuePasswordByAdmin(RequestContext context) {

        Account command = (Account) context.getFlowScope().getRequired(
                "account", Account.class);
        Account account = accountTable.findByMailAddr(command.getMailAddr());
        if (account == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("The mail address '" + command.getMailAddr()
                        + "' not found.");
            }
            context.getMessageContext().addMessage(new MessageBuilder()
                .error().source("mailAddr")
                .code("account.validation.mailAddrNotFound").build());
            return error();
        }

        // VpX[hs
        MailAddrAndPassword mailAddrAndPassword = reissuePassword(account);

        context.getFlashScope().put("mailAddrAndPassword", mailAddrAndPassword);
        return success();
    }

    private MailAddrAndPassword reissuePassword(Account account) {
        String newPassword = Account.createRandomPassword(4, 8);
        account.setPlainPassword(newPassword);
        account.encrypt();
        try {
            account.store();
        } catch (MailAddrUsedByOtherException e) {
            logger.error(e);
            throw new IllegalStateException(e);
        }
        return  new MailAddrAndPassword(account.getMailAddr(), newPassword);
    }
}
