package org.unitedfront2.web.controller.account;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.AccountTable;
import org.unitedfront2.domain.MailAddrUsedByOtherException;
import org.unitedfront2.web.WebUtils;

/**
 * pX[hύXANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "accountPasswordChangeAction")
public class PasswordChangeAction extends MultiAction {

    /** AJEge[u */
    @Autowired
    private AccountTable accountTable;

    /**
     * pX[hύX܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     */
    public Event changePassword(RequestContext context) {
        Account command = (Account) context.getFlowScope().get("account",
                Account.class);
        Account account = accountTable.find(
                WebUtils.getAccount(context).getId());
        command.copyPasswordTo(account);
        if (!account.isEncrypted()) {
            account.encrypt();
        }
        try {
            account.store();
        } catch (MailAddrUsedByOtherException e) {
            logger.warn(e.getMessage());
            throw new IllegalStateException(e);
        }
        return success();
    }
}
