package org.unitedfront2.web.controller.account;

import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.AccountTable;
import org.unitedfront2.domain.MailAddrAndPassword;
import org.unitedfront2.domain.MailAddrUsedByOtherException;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.mail.MailService;

/**
 * pX[hύX̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "accountMailAddrChangeAction")
public class MailAddrChangeAction extends MultiAction {

    /** AJEge[u */
    @Autowired
    private AccountTable accountTable;

    /** [MT[rX */
    @Autowired
    private MailService mailService;

    /**
     * [AhX̕ύXƃpX[h̍Ĕss܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     * @throws MailAddrUsedByOtherException [AhXɎgĂ
     */
    public Event changeMailAddr(RequestContext context)
        throws MailAddrUsedByOtherException {

        int id = WebUtils.getAccount(context).getId();
        Account oldAccount = (Account) context.getFlowScope().getRequired(
                "account", Account.class);
        String newMailAddr = oldAccount.getMailAddr();
        String newPassword = Account.createRandomPassword(4, 8);

        Account newAccount = accountTable.find(id);
        newAccount.setMailAddr(newMailAddr);
        newAccount.setPlainPassword(newPassword);
        newAccount.encrypt();
        try {
            newAccount.store();
        } catch (MailAddrUsedByOtherException e) {
            logger.warn(e.getMessage());
            throw new IllegalStateException(e);
        }

        MailAddrAndPassword mailAddrAndPassword
            = new MailAddrAndPassword(newMailAddr, newPassword);

        Map<String, Object> model = new HashMap<String, Object>();
        model.put("mailAddrAndPassword", mailAddrAndPassword);
        mailService.send("account.MailAddrChange-mail", model,
                WebUtils.getLocale(context));

        context.getFlowScope().put("mailAddrAndPassword", mailAddrAndPassword);
        return success();
    }
}
