package org.unitedfront2.web.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.DomainFactory;
import org.unitedfront2.domain.Installer;
import org.unitedfront2.domain.MailAddrAndPassword;
import org.unitedfront2.domain.MailAddrUsedByOtherException;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.SimpleUserTable;
import org.unitedfront2.domain.UserCodeUsedByOtherException;
import org.unitedfront2.domain.UserNameUsedByOtherException;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.mail.MailService;

/**
 * [U̐VKo^sANVNXłB
 *
 * @author kurokkie
 *
 */
// CXg[ݒ肷Kv邽߁AapplicationContext-controller.xml t@C Bean
// `
public class RegistrationAction extends MultiAction {

    /** hCt@Ng */
    @Autowired
    private DomainFactory domainFactory;

    /** [Ue[u */
    @Autowired
    private SimpleUserTable simpleUserTable;

    /** [MT[rX */
    @Autowired
    private MailService mailService;

    /** CXg[Xg */
    private List<Installer> installers = new ArrayList<Installer>(0);

    /**
     * VKo^s܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     * @throws MailAddrUsedByOtherException [AhXɎgĂ邽ߓo^ł
     * Aɏꂽ悤ɐUBCӂ̃[AhXo^Ă邩mF
     * Ił̋@\𗘗płȂ悤ɁB
     */
    public Event register(RequestContext context)
        throws MailAddrUsedByOtherException {

        // AJEg
        Account commandAccount
            = (Account) context.getFlowScope().getRequired("account");
        String mailAddr = commandAccount.getMailAddr();
        String plainPassword = Account.createRandomPassword(4, 8);
        Account account = domainFactory.prototype(Account.class);
        account.setMailAddr(mailAddr);
        account.setPlainPassword(plainPassword);
        account.addRole(Account.Role.ROLE_USER);
        account.setStatus(Account.Status.AVAILABLE);
        account.encrypt();
        try {
            account.store();
        } catch (MailAddrUsedByOtherException e) {
            logger.debug(e.getMessage());
            Map<String, Object> model = new HashMap<String, Object>();
            model.put("account", account);
            mailService.send("RegistrationFailure-mail", model,
                    WebUtils.getLocale(context));
            return error();
        }

        // [U
        SimpleUser commandUser
            = (SimpleUser) context.getFlowScope().getRequired("user");
        SimpleUser user = domainFactory.prototype(SimpleUser.class);
        user.setId(account.getId());
        user.setCode(commandUser.getCode());
        user.setName(commandUser.getName());
        try {
            simpleUserTable.install(user);
        } catch (UserCodeUsedByOtherException e) {
            throw new IllegalStateException(e);
        } catch (UserNameUsedByOtherException e) {
            throw new IllegalStateException(e);
        }

        for (Installer installer : installers) {
            installer.install(account.getId());
        }

        MailAddrAndPassword mailAddrAndPassword
            = new MailAddrAndPassword(mailAddr, plainPassword);

        // [M
        Map<String, Object> model = new HashMap<String, Object>();
        model.put("mailAddrAndPassword", mailAddrAndPassword);
        mailService.send("Registration-mail", model,
                WebUtils.getLocale(context));

        context.getFlashScope().put("mailAddrAndPassword", mailAddrAndPassword);

        return success();
    }

    public void setInstallers(List<Installer> installers) {
        this.installers = installers;
    }
}
