package org.unitedfront2.web.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.annotation.Resource;
import javax.servlet.ServletContext;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.context.ServletContextAware;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;
import org.unitedfront2.domain.Domain;
import org.unitedfront2.domain.DomainFactory;
import org.unitedfront2.validation.SpringValidator;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.mail.MailSendException;
import org.unitedfront2.web.mail.MailSender;
import org.unitedfront2.web.mail.SimpleMailMessageValidator;
import org.unitedfront2.web.mail.WebXmlTemplateSpringMailSender;
import org.unitedfront2.web.mail.XmlTemplateSpringMailSender;

/**
 * ̓tH[p̃ANVNXłBhCt@Ng <code>{@link DomainFactory}</code> 
 * gtH[IuWFNg̐ݒ⃁[Z_ <code>{@link MailSender}</code> g[
 * M̎xA؃NX {@link SpringValidator} g؃NX̃r[ւ̓]Ȃǂ񋟂
 * ܂BhCt@Ngƃ[Z_̐ݒ͔CӂłBhCt@Ngݒ肳ĂăvpeBϐ
 * <code>formObjectClass</code> ɒlݒ肳ĂȂꍇA
 * <code>formObjectClass</code> ɂ̓hCt@NgŐNXݒ肳܂B<p>
 *
 * [̑Mɂ́A[ev[gGW {@link SpringMailServiceImpl} 𗘗p
 * ܂B[ev[gł́AVXẽ[AhX URL ƂēnƂł܂B
 *
 * @author kurokkie
 */
public class FormAction extends org.springframework.webflow.action.FormAction
    implements ServletContextAware {

    /** ؃NX̕ϐ (validator) */
    public static final String VALIDATOR_PARAM_NAME = "validator";

    /** VXe[AhX̕ϐ (_systemMailAddr) */
    public static final String SYSYSTEM_MAIL_ADDR_PARAM_NAME
        = "_systemMailAddr";

    /** VXe URL ̕ϐ (_systemUrl) */
    public static final String SYSYSTEM_URL_PARAM_NAME = "_systemUrl";

    /** [MtO̕ϐ (sendMail) */
    public static final String SEND_MAIL_PARAM_NAME = "sendMail";

    /** [Jݒt@C Bean  (localConfiguration) */
    public static final String LOCAL_CONFIGURATION_BEAN_NAME
        = "localConfiguration";

    /** hCt@Ng */
    @Autowired
    protected DomainFactory domainFactory;

    /** [MGW */
    @Resource(name = "mailSender")
    private org.springframework.mail.MailSender mailSenderTarget;

    /** [bZ[W؃NX */
    @Resource(name = "simpleMailMessageValidator")
    private SimpleMailMessageValidator simpleMailMessageValidator;

    /** [Mev[gGWXg */
    private final List<XmlTemplateSpringMailSender> mailSenders
        = new ArrayList<XmlTemplateSpringMailSender>();

    /**
     * ̃NXݒ肷邽߂̃vpeBłB
     *
     * <table>
     *   <tr>
     *     <th>L[</th>
     *     <th></th>
     *   </tr>
     *   <tr>
     *     <td>mail.sendMail</td>
     *     <td>
     *       [MLɂꍇ <code>true</code> Aɂꍇ
     *       <code>false</code> BftHg <code>false</code> B
     *     </td>
     *   </tr>
     *   <tr>
     *     <td>mail.systemMailAddr</td>
     *     <td>VXẽ[AhXB[ev[g̕ϐƂėp܂B</td>
     *   </tr>
     *   <tr>
     *     <td>mail.systemUrl</td>
     *     <td>VXe URL B[ev[g̕ϐƂėp܂B</td>
     *   </tr>
     *   <tr>
     *     <td>mail.subjectPrefix</td>
     *     <td>[̌̑Oɕt^ړBftHg͋󕶎B</td>
     *   </tr>
     *   <tr>
     *     <td>mail.signature</td>
     *     <td>[̖{̍Ōɂ鏐BftHg͋󕶎B</td>
     *   </tr>
     * </table>
     */
    @Resource(name = "formActionConfig")
    private Properties config;

    /**
     * [MsȂ true AłȂ false
     *
     * @see #putSendMail(RequestContext)
     * @see #isSendMail()
     */
    private boolean sendMail;

    /** VXe[AhX */
    private String systemMailAddr;

    /** VXe URL */
    private String systemUrl;

    /** ̐ړ */
    private String subjectPrefix;

    /**  */
    private String signature;

    /** {@link ServletContext} */
    private ServletContext servletContext;

    /**
     * vpeB <code>formErrorsScope</code> ̒l {@link ScopeType#FLOW} ɐݒ肵
     * BeNXł̓ftHg {@link ScopeType#FLASH} ɂȂĂ܂B
     */
    public FormAction() {
        super();
        setFormErrorsScope(ScopeType.FLOW);
    }

    /**
     * hCt@Ngݒ肳ĂăvpeBϐ <code>formObjectClass</code> ɒlݒ肳
     * ĂȂꍇA<code>formObjectClass</code> ɂ̓hCt@NgŐNXݒ
     * ܂B[Mev[g̐͂̃\bhōs܂B
     */
    @Override
    protected void initAction() {
        super.initAction();

        // ݒ
        this.sendMail = Boolean.valueOf(config.getProperty("mail.sendMail",
                "false"));
        this.systemMailAddr = config.getProperty("mail.systemMailAddr");
        this.systemUrl = config.getProperty("mail.systemUrl");
        this.subjectPrefix = config.getProperty("mail.subjectPrefix", "");
        this.signature = config.getProperty("mail.signature", "");

        // [Mev[gGW̏
        for (XmlTemplateSpringMailSender mailSender : mailSenders) {
            initMailSender(mailSender);
        }
    }

    private void initMailSender(XmlTemplateSpringMailSender mailSender) {
        mailSender.setMailSender(mailSenderTarget);
        mailSender.setSubjectPrefix(subjectPrefix);
        mailSender.setSignature(signature);
        mailSender.setSimpleMailMessageValidator(simpleMailMessageValidator);
    }

    /**
     * {@link org.springframework.webflow.action.FormAction#setupForm(
     * RequestContext)} ĂяoA؃NXݒ肵܂B̃\bh̓tH[\xɌ
     * яo܂BANZX͂A؃G[ɂĖ߂ĂۂɂĂяo܂B
     *
     * @param context {@link RequestContext}
     * @return {@link Event}
     * @throws Exception {@link Exception}
     * @see SpringValidator
     */
    @Override
    public Event setupForm(RequestContext context) throws Exception {
        Event event = super.setupForm(context);
        MutableAttributeMap requestScope = context.getRequestScope();
        Validator validator = getValidator();
        if (validator instanceof SpringValidator) {
            requestScope.put(VALIDATOR_PARAM_NAME,
                    ((SpringValidator<?>) validator).getOriginalValidator());
            if (logger.isDebugEnabled()) {
                logger.debug("Set the validator [" + ((SpringValidator<?>)
                        validator).getOriginalValidator() + "]");
            }
        } else {
            requestScope.put(VALIDATOR_PARAM_NAME, validator);
            if (logger.isDebugEnabled()) {
                logger.debug("Set the validator [" + validator + "]");
            }
        }
        return event;
    }

    /**
     * {@link org.springframework.webflow.action.FormAction}  getFormObject
     * ̃VOl` {@link Exception} 𔭐dlɂȂĂgɂ߁AgĂ܂B
     *
     * @param context NGXgReLXg
     * @return tH[IuWFNg
     * @throws IllegalArgumentException s
     */
    @Override
    protected Object getFormObject(RequestContext context)
        throws IllegalArgumentException {
        try {
            return super.getFormObject(context);
        } catch (Exception e) {
            logger.error(e);
            throw new IllegalArgumentException(e);
        }
    }

    /**
     * tH[IuWFNg𐶐܂BhCt@Ngݒ肳Ă΂ <code>prototype
     * </code> \bhpăhCIuWFNg𐶐Aݒ肳ĂȂ
     * {@link org.springframework.webflow.action.FormAction#createFormObject}
     * sēlԂ܂B
     *
     * @param context NGXgReLXg
     * @return tH[IuWFNg
     * @throws Exception O
     * @see org.springframework.webflow.action.FormAction#createFormObject
     */
    @Override
    protected Object createFormObject(RequestContext context) throws Exception {
        Class<?> formObjectClass = getFormObjectClass();
        if (domainFactory != null
                && Domain.class.isAssignableFrom(formObjectClass)) {
            return domainFactory.prototype(getFormObjectClass());
        } else {
            return super.createFormObject(context);
        }
    }

    @Override
    public Event bindAndValidate(RequestContext context) throws Exception {
        Event e =  super.bindAndValidate(context);
        if (logger.isDebugEnabled()) {
            Errors errors = getFormErrors(context);
            if (errors.hasErrors()) {
                logger.debug(errors);
            }
        }
        return e;
    }

    /**
     * s܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     * @ensure t[XR[vɁAϐ {@link #SEND_MAIL_PARAM_NAME} ̒lݒ肳
     */
    public Event init(RequestContext context) {
        context.getFlowScope().put(SEND_MAIL_PARAM_NAME, sendMail);
        return success();
    }

    /**
     * [𑗐MANVłB{@link #doSendMail(RequestContext)} ĂяoA
     * CxgԂ܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     * @throws Exception {@link Exception}
     */
    public Event sendMail(RequestContext context) throws Exception {
        doSendMail(context);
        return success();
    }

    /**
     * [̑Ms܂B̃\bh́A[ev[gݒ肵ꍇɂ̂ݗLłB
     * ̃[ev[gݒ肵Ăꍇ́A{@link #doSendMail(RequestContext, String)}
     * 𗘗pĂB
     *
     * @param context {@link RequestContext}
     * @throws MailSendException [MɎs
     */
    protected void doSendMail(RequestContext context) throws MailSendException {
        if (mailSenders.size() != 1) {
            String message = "The 'one' mailTemplateName must be set.";
            throw new IllegalStateException(message);
        }
        doSendMail(context, mailSenders.get(0).getMailTemplateName());
    }

    /**
     * [̑Ms܂B[MtOLɂȂĂKv܂BNGXgXR[vɕۑ
     * Ă郂fƁAVXẽ[AhX URL [Mev[gGWɈn܂B<p>
     *
     * [M@\ANVNXł́A{@link #sendMail(RequestContext)} 
     * pł܂B̃[M@\ꍇÃ\bhTuNX̃[M@\łōė
     * pĂB
     *
     * @param context {@link RequestContext}
     * @param mailTemplateName ݒς݂̃[ev[g
     * @throws MailSendException [MɎs
     * @see #setMailTemplateNames(List)
     * @see #SYSYSTEM_MAIL_ADDR_PARAM_NAME
     * @see #SYSYSTEM_URL_PARAM_NAME
     */
    protected void doSendMail(RequestContext context, String mailTemplateName)
        throws MailSendException {
        if (!sendMail) {
            String message = "This action has been set No send mail.";
            logger.error(message);
            throw new IllegalStateException(message);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Sending mail.");
        }
        Map<String, Object> model = context.getFlashScope().asMap();
        model.put(SYSYSTEM_MAIL_ADDR_PARAM_NAME, systemMailAddr);
        model.put(SYSYSTEM_URL_PARAM_NAME, systemUrl);
        Locale locale = WebUtils.getLocale(context);
        MailSender mailSender = selectMailSender(mailTemplateName);
        if (mailSender == null) {
            String message = "The mailTemplateName '" + mailTemplateName
                + "' is null.";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        mailSender.send(model, locale);
        if (logger.isInfoEnabled()) {
            logger.info("Send mail successfully.");
        }
    }

    private MailSender selectMailSender(String mailTemplateName) {
        for (XmlTemplateSpringMailSender sender : mailSenders) {
            if (sender.supports(mailTemplateName)) {
                return sender;
            }
        }
        return null;
    }

    /**
     * oCh̃G[Ԃ܂BtH[IuWFNgɂ́A{@link #getFormObjectName()} Ŏ
     * lgp܂BG[ {@link #getFormErrorsScope()} Ŏ擾XR[vɐݒ
     * ܂B
     *
     * @param context {@link RequestContext}
     * @param formObject tH[IuWFNg
     * @return {@link Errors}
     */
    protected Errors getBindingErrors(RequestContext context,
        Object formObject) {

        try {
            // @deprecated #bindAndValidateɍ킹
            Errors errors = createBinder(context, formObject).getErrors();
            putFormErrors(context, errors);
            return errors;
        } catch (Exception e) {
            logger.error(e);
            throw new IllegalStateException(e);
        }
    }

    /**
     * oCh̃G[Ԃ܂BtH[IuWFNg𖾎IɎwł܂BG[
     * {@link #getFormErrorsScope()} Ŏ擾XR[vɐݒ肵܂B
     *
     * @param context {@link RequestContext}
     * @param formObject tH[IuWFNg
     * @param formObjectName tH[IuWFNg
     * @return {@link Errors}
     */
    protected Errors getBindingErrors(RequestContext context, Object formObject,
        String formObjectName) {

        try {
            // @deprecated #bindAndValidateɍ킹
            Errors errors = createBinder(context, formObject, formObjectName)
                .getErrors();
            putFormErrors(context, errors);
            return errors;
        } catch (Exception e) {
            logger.error(e);
            throw new IllegalStateException(e);
        }
    }

    /**
     * Put given errors instance in the configured scope of given context.
     *
     * eNXɂ݂ private \bhłB
     * {@link #getBindingErrors(RequestContext, Object)} \bhŌĂяo悤ɂĂ
     * ߁ATuNXɂ͌JĂ܂B
     *
     * @param context {@link RequestContext}
     * @param errors {@link Errors}
     */
    private void putFormErrors(RequestContext context, Errors errors) {
        if (logger.isDebugEnabled()) {
            logger.debug("Putting form errors instance in scope "
                + getFormErrorsScope());
        }
        getFormObjectAccessor(context).putFormErrors(errors,
            getFormErrorsScope());
    }

    /**
     * ReLXgɃtH[IuWFNgĐݒ肵܂B
     *
     * @param context {@link RequestContext}
     * @param formObject tH[IuWFNg
     */
    protected void putFormObject(RequestContext context, Object formObject) {
        if (logger.isDebugEnabled()) {
            logger.debug("Putting form object '" + formObject
                    + "' in scope " + getFormObjectScope()
                    + " with name '" + getFormObjectName() + "'");
        }
        getFormObjectAccessor(context).putFormObject(formObject,
            getFormObjectName(), getFormObjectScope());
    }

    /**
     * Create a new binder instance for the given form object and request
     * context. Can be overridden to plug in custom DataBinder subclasses.
     * <p>
     * Default implementation creates a standard WebDataBinder, and invokes
     * {@link #initBinder(RequestContext, DataBinder)} and
     * {@link #registerPropertyEditors(
     *     org.springframework.beans.PropertyEditorRegistry)}.
     * @param context the action execution context, for accessing and setting
     * data in "flow scope" or "request scope"
     * @param formObject the form object to bind onto
     * @param formObjectName the form object name
     * @return the new binder instance
     * @throws Exception when an unrecoverable exception occurs
     * @see WebDataBinder
     * @see #initBinder(RequestContext, DataBinder)
     * @see #setMessageCodesResolver(
     *     org.springframework.validation.MessageCodesResolver)
     */
    protected DataBinder createBinder(RequestContext context, Object formObject,
        String formObjectName) throws Exception {

        DataBinder binder = new WebDataBinder(formObject, formObjectName);
        if (getMessageCodesResolver() != null) {
            binder.setMessageCodesResolver(getMessageCodesResolver());
        }
        initBinder(context, binder);
        registerPropertyEditors(context, binder);
        return binder;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected boolean isSendMail() {
        return sendMail;
    }

    /**
     * [Mev[gGW {@link XmlTemplateSpringMailSender} ̂߂̃[
     * ev[gXgݒ肵܂B̃ev[ggpꍇɎg܂B
     *
     * @param mailTemplateNames [ev[gXg
     * @see #setMailTemplateName(String)
     */
    protected void setMailTemplateNames(List<String> mailTemplateNames) {
        setMailTemplateNames(mailTemplateNames.toArray(
                new String[mailTemplateNames.size()]));
    }

    /**
     * [Mev[gGW {@link XmlTemplateSpringMailSender} ̂߂̃[
     * ev[gXgݒ肵܂B̃ev[ggpꍇɎg܂B
     *
     * @param mailTemplateNames [ev[gz
     * @see #setMailTemplateName(String)
     */
    protected void setMailTemplateNames(String[] mailTemplateNames) {
        this.mailSenders.clear();
        for (String mailTemplateName : mailTemplateNames) {
            XmlTemplateSpringMailSender mailSender
                = new WebXmlTemplateSpringMailSender(mailTemplateName,
                        servletContext);
            initMailSender(mailSender);
            this.mailSenders.add(mailSender);
        }
    }

    /**
     * [Mev[gGW {@link XmlTemplateSpringMailSender} ̂߂̃[
     * ev[gݒ肵܂BP̃ev[ggpꍇɎg܂B
     *
     * @param mailTemplateName [ev[g
     * @see #setMailTemplateNames(List)
     */
    protected void setMailTemplateName(String mailTemplateName) {
        setMailTemplateNames(new String[] {mailTemplateName});
    }

    protected DomainFactory getDomainFactory() {
        return domainFactory;
    }
}
