package org.unitedfront2.domain.communication;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import org.unitedfront2.domain.Domain;
import org.unitedfront2.domain.accesscontrol.AccessControl;

/**
 * PXbh^̃R~jeBłB
 *
 * @invariant ${this.thread.overview} equals ${this.overview}
 * @invariant ${this.thread.ownerId} equals ${this.ownerId}
 * @invariant ${this.thread.readAccessControl} equals ${this.readAccessControl}
 * @invariant ${this.thread.writeAccessControl} equals
 * ${this.writeAccessControl}
 * @invariant ${this.thread.postAccessControl} equals ${this.postAccessControl}
 *
 * @author kurokkie
 *
 */
public class SingleThreadCommunity extends AbstractCommunity
    implements Serializable, Domain {

    /** VAԍ */
    private static final long serialVersionUID = -1131508329939121582L;

    /** Xbh */
    private transient Thread thread;

    public SingleThreadCommunity() {
        super();
    }

    public SingleThreadCommunity(Integer id, String code, Message overview,
            Integer ownerId, AccessControl readAccessControl,
            AccessControl writeAccessControl, AccessControl postAccessControl) {
        super(id, code, overview, ownerId, readAccessControl,
                writeAccessControl, postAccessControl);
    }

    public SingleThreadCommunity(String code, Message overview,
            Integer ownerId, AccessControl readAccessControl,
            AccessControl writeAccessControl, AccessControl postAccessControl) {
        super(code, overview, ownerId, readAccessControl, writeAccessControl,
                postAccessControl);
    }

    @Override
    public boolean isDeletable() {
        if (getCount() == null) {
            return false;
        }
        return getCount() == 0;
    }

    /** VKo^ɂ́AXbhɓo^܂B */
    @Override
    public void store() throws CommunityCodeUsedByOtherException {
        if (getId() == null) {
            // VKo^
            super.store();
            registerThread();
        } else {
            // XV
            super.store();
            List<Thread> threads = getCommunityDao().findThreads(getId());
            if (threads.isEmpty()) {
                registerThread();
            }
        }
    }

    private void registerThread() {
        Thread t = getDomainFactory().prototype(Thread.class);
        t.setOverview(getOverview());
        t.setOwnerId(getOwnerId());
        t.setReadAccessControl(getReadAccessControl());
        t.setWriteAccessControl(getWriteAccessControl());
        t.setPostAccessControl(getPostAccessControl());
        t.store();
        getCommunityDao().registerThread(getId(), t.getId());
        this.thread = t;
    }

    @Override
    public void delete() throws CannotDeleteCommunityException {
        try {
            getThread().delete();
        } catch (CannotDeleteThreadException e) {
            throw new CannotDeleteCommunityException(e);
        }
        super.delete();
    }

    @Override
    public <C extends Community> boolean canChangeTo(Class<C> clazz) {
        if (clazz == SingleThreadCommunity.class) {
            return true;
        }
        if (clazz == MultiThreadCommunity.class) {
            return true;
        } else {
            String message = "The community type '" + clazz.getClass().getName()
                 + "' not supported.";
            logger.error(message);
            throw new UnsupportedOperationException(message);
        }
    }

    @Override
    protected <C extends Community> C doChangeTo(Class<C> clazz) {
        if (clazz == SingleThreadCommunity.class) {
            return (C) this;
        }
        if (clazz == MultiThreadCommunity.class) {
            return (C) getDomainFactory().prototype(
                    new MultiThreadCommunity(getId(), getCode(), getOverview(),
                            getOwnerId(), getReadAccessControl(),
                            getWriteAccessControl(), getPostAccessControl()));
        } else {
            String message = "The community type '" + clazz.getClass().getName()
                 + "' not supported.";
            logger.error(message);
            throw new UnsupportedOperationException(message);
        }
    }

    public void post(Message message) {
        getThread().post(message);
    }

    public void retrieveEntries(int no, int num) {
        getThread().retrieveEntries(no, num);
    }

    /**
     * LȂΊTv̓o^AL݂΁AŐV̓o^Ԃ܂B
     */
    @Override
    public Date getLastUpdateDate() {
        if (super.getLastUpdateDate() == null && getThread() != null) {
            retrieveEntries(0, 1);
            if (getThread().getEntries().isEmpty()) {
                setLastUpdateDate(getOverview().getLastUpdateDate());
            } else {
                setLastUpdateDate(getThread().getEntries().get(0)
                        .getRegistrationDate());
            }
        }
        return super.getLastUpdateDate();
    }

    @Override
    public Thread getThread() {
        if (thread == null && getCommunityDao() != null && getId() != null) {
            List<Thread> threads = getCommunityDao().findThreads(getId());
            if (threads.isEmpty()) {
                String message = "Thread not found.";
                logger.warn(message);
                return null;
            } else if (threads.size() == 1) {
                this.thread = threads.get(0);
            } else {
                String message = "This community is multi thread.";
                logger.error(message);
                throw new IllegalStateException(message);
            }
        }
        return this.thread;
    }

    @Override
    public void deleteThread(int threadId) throws CannotDeleteThreadException {
        throw new CannotDeleteThreadException(
                "Cannot delete this thread of single thread community.");
    }

    public Integer getThreadId() {
        if (getThread() == null) {
            return null;
        } else {
            return getThread().getId();
        }
    }

    /**
     * Xbhێ鑍LԂ܂B
     *
     * @return L
     */
    public Integer getCount() {
        if (getThread() == null) {
            return null;
        }
        return getThread().getCount();
    }

    public List<Message> getEntries() {
        if (getThread() == null) {
            return null;
        }
        return getThread().getEntries();
    }
}
