package org.unitedfront2.domain.communication;

import java.util.List;

import org.unitedfront2.dao.MailDao;
import org.unitedfront2.domain.EmailForwarding;
import org.unitedfront2.domain.EmailForwardingTable;

/**
 * [e[uW[łB
 *
 * @author kurokkie
 *
 */
public class MailTable {

    /** [̃f[^ANZXIuWFNg */
    private MailDao mailDao;

    /** e []ݒe[u */
    private EmailForwardingTable emailForwardingTable;

    /**
     * [擾܂B
     *
     * @param id ID
     * @return [AȂ <code>null</code>
     */
    public Mail find(int id) {
        return mailDao.find(id);
    }

    /**
     * [XbhƂĎ擾܂B
     *
     * @param id ID
     * @return Xbh̃[gƂȂ郁[AȂ <code>null</code>
     */
    public Mail findThread(int id) {
        return mailDao.findThread(id);
    }

    /**
     * w肵R[h[XbhƂĎ擾܂B
     *
     * @param code R[h
     * @return Xbh̃[gƂȂ郁[AȂ <code>null</code>
     */
    public Mail findThreadByCode(String code) {
        return mailDao.findThreadByCode(code);
    }

    /**
     * w肵y[W̃[Xbhꗗ擾܂B[XgTu[܂߂XbhƂĎ擾
     * BXbhōŐV̑M[̑M̍~̃XgłB
     *
     * @param ownerId L҂̃[U ID
     * @param no JngXbhԍ
     * @param num 擾
     * @return [XbhXg
     */
    public List<Mail> findThreads(int ownerId, int no, int num) {
        return mailDao.findThreads(ownerId, no, num);
    }

    /**
     * ${ownerId} [Xbȟ擾܂B
     *
     * @param ownerId L ID
     * @return [Xbȟ
     */
    public int countThreads(int ownerId) {
        return mailDao.countThreads(ownerId);
    }

    /**
     * [U̖ǃ[̌擾܂B
     *
     * @param ownerId [U ID
     * @return ǃ[
     */
    public int countUnreadMail(int ownerId) {
        return mailDao.countUnreadMail(ownerId);
    }

    /**
     * [U̖ǃ[邩ǂʂ܂B
     *
     * @param ownerId [U ID
     * @return ǃ[ꍇ <code>true</code> AłȂ
     *     <code>false</code>
     */
    public boolean hasUnreadMail(int ownerId) {
        return countUnreadMail(ownerId) > 0;
    }

    /**
     * e-[ւ̓]sݒɂȂĂ邩ǂB
     *
     * @param userId [U ID
     * @return ]sݒɂȂĂꍇ <code>true</code> AȂĂȂȂ
     *     <code>false</code>
     */
    public boolean isForwarding(int userId) {
        return emailForwardingTable.find(userId, EmailForwarding.MAIL);
    }

    public void setMailDao(MailDao mailDao) {
        this.mailDao = mailDao;
    }

    public void setEmailForwardingTable(
            EmailForwardingTable emailForwardingTable) {
        this.emailForwardingTable = emailForwardingTable;
    }
}
