package org.unitedfront2.domain.communication;

import java.util.Date;
import java.util.List;

import org.unitedfront2.domain.Deletable;
import org.unitedfront2.domain.Identifiable;
import org.unitedfront2.domain.Storable;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.accesscontrol.AccessControl;
import org.unitedfront2.domain.accesscontrol.AccessDeniedException;
import org.unitedfront2.domain.accesscontrol.Resource;

/**
 * R~jeB\C^[tF[XłB
 *
 * <div><img src="doc-files/Community.png" alt="NX}"/></div>
 *
 * @invariant ${this.ownerId} is ${this.overview.ownerId}
 * @invariant ${this.overview.authorId} is ${this.overview.ownerId}
 * @invariant ${this.readAccessControl} equals
 * ${this.overview.readAccessControl}
 * @invariant ${this.writeAccessControl} equals
 * ${this.overview.writeAccessControl}
 * @invariant ${this.writeAccessControl.type} is
 * {@link org.unitedfront2.domain.accesscontrol.OwnerOnly}
 *
 * @author kurokkie
 *
 */
public interface Community extends Resource, Identifiable<Community>, Storable,
    Deletable {

    /**
     * ҏW͕K {@link org.unitedfront2.domain.accesscontrol.OwnerOnly} 
     * 肳܂BR[hdĂȂǂmFAdĂ
     * {@link CommunityCodeUsedByOtherException} 𔭐܂BVKo^ɂ͏L҂̃}
     * CR~jeBɂ̃R~jeBǉ܂B܂AXVɎQƌ[ÚAIɃR
     * ~jeBމs܂B
     */
    @Override
    void store() throws CommunityCodeUsedByOtherException;

    /**
     * @throws CannotDeleteCommunityException R~jeB폜łȂ
     */
    @Override
    void delete() throws CannotDeleteCommunityException;

    /**
     * R~jeB̃^CvύXR~jeBԂ܂BvpeB́Ap邾p܂BύX
     * sꍇ {@link CannotChangeCommunityException} ܂BύXɐ
     * ǂ {@link #canChangeTo(Class)} \bhŊm߂邱Ƃł܂B
     *
     * @param <C> R~jeB
     * @param clazz R~jeBNX
     * @return ύX̐VR~jeB
     * @throws CannotChangeCommunityException ^Cv̕ύXɎs
     */
    <C extends Community> C changeTo(Class<C> clazz)
        throws CannotChangeCommunityException;

    /**
     * R~jeB̃^CvύXR~jeBԂ܂B
     *
     * @param <C> R~jeB
     * @param className R~jeBNX
     * @return ύX̐VR~jeB
     * @throws CannotChangeCommunityException ^Cv̕ύXɎs
     * @see #canChangeTo(Class)
     */
    <C extends Community> C changeTo(String className)
        throws CannotChangeCommunityException;

    /**
     * w肵R~jeBɕύX\ǂ𔻒肵܂B
     *
     * @param <C> R~jeB
     * @param clazz R~jeBNX
     * @return ύX\Ȃ <code>true</code> As\Ȃ <code>false</code>
     */
    <C extends Community> boolean canChangeTo(Class<C> clazz);

    /**
     * w肵R~jeBɕύX\ǂ𔻒肵܂B
     *
     * @param <C> R~jeB
     * @param className R~jeBNX
     * @return ύX\Ȃ <code>true</code> As\Ȃ <code>false</code>
     */
    <C extends Community> boolean canChangeTo(String className);

    /**
     * ̃R~jeBɎQł邩ǂ𔻒肵܂B
     *
     * @param user [U
     * @return QȂ <code>true</code> AłȂȂ <code>false</code>
     */
    boolean isMyCommunity(User user);

    /**
     * ̃R~jeBɎQ܂B
     *
     * @param userId [U ID
     * @throws CannotEntryCommunityException ɂ̃R~jeBɎQĂ
     */
    void entry(int userId) throws CannotEntryCommunityException;

    /**
     * ̃R~jeBɎQ܂B
     *
     * @param user [U
     * @throws CannotEntryCommunityException ɂ̃R~jeBɎQĂ
     */
    void entry(User user) throws CannotEntryCommunityException;

    /**
     * ̃R~jeBމ܂B
     *
     * @param userId [U ID
     * @throws CannotCancelCommunityException L҂Ȃ̂őމłȂA܂͉łȂ
     */
    void cancel(int userId) throws CannotCancelCommunityException;

    /**
     * ̃R~jeBމ܂B
     *
     * @param user [U
     * @throws CannotCancelCommunityException L҂Ȃ̂őމłȂA܂͉łȂ
     */
    void cancel(User user) throws CannotCancelCommunityException;

    /**
     * [UœeANZX݂܂B
     *
     * @throws AccessDeniedException ANZX
     */
    void postAccess() throws AccessDeniedException;

    /**
     * eANZX݂܂B
     *
     * @param userId [U ID
     * @throws AccessDeniedException ANZX
     */
    void postAccess(int userId) throws AccessDeniedException;

    /**
     * eANZX݂܂B${user}  <code>null</code> łΓ[UƂ݂Ȃ܂B
     *
     * @param user [U
     * @throws AccessDeniedException ANZX
     */
    void postAccess(User user) throws AccessDeniedException;

    /**
     * [UɓeANZX邩肵܂B
     *
     * @return  <code>true</code> AȂ <code>false</code>
     */
    boolean canPost();

    /**
     * eANZX邩肵܂B${user}  <code>null</code> łΓ[UƂ
     * Ȃ܂B
     *
     * @param userId [U ID
     * @return  <code>true</code> AȂ <code>false</code>
     */
    boolean canPost(int userId);

    /**
     * eANZX邩肵܂B
     *
     * @param user [U
     * @return  <code>true</code> AȂ <code>false</code>
     */
    boolean canPost(User user);

    /**
     * w肵Xbh擾܂BƂ݂ĂXbhłƂĂÃR~jeBɊ֘A
     * ꍇ͌ȂƔf null Ԃ܂B
     *
     * @param id Xbh ID
     * @return XbhAȂ null
     */
    Thread findThread(int id);

    /**
     * w肵Xbh{Ŏ擾܂BƂ݂ĂXbhłƂĂÃR~jeB
     * Ɋ֘AȂꍇ͌ȂƔf null Ԃ܂B
     *
     * @param id Xbh ID
     * @param user [U
     * @return Xbh
     * @throws AccessDeniedException ANZX
     */
    Thread findThreadForRead(int id, User user)
        throws AccessDeniedException;

    /**
     * w肵XbhҏWŎ擾܂BƂ݂ĂXbhłƂĂÃR~jeB
     * Ɋ֘AȂꍇ͌ȂƔf null Ԃ܂B
     *
     * @param id Xbh ID
     * @param user [U
     * @return Xbh
     * @throws AccessDeniedException ANZX
     */
    Thread findThreadForWrite(int id, User user)
        throws AccessDeniedException;

    /**
     * w肵Xbh𓊍eŎ擾܂BƂ݂ĂXbhłƂĂÃR~jeB
     * Ɋ֘AȂꍇ͌ȂƔf null Ԃ܂B
     *
     * @param id Xbh ID
     * @param user [U
     * @return Xbh
     * @throws AccessDeniedException ANZX
     */
    Thread findThreadForPost(int id, User user)
        throws AccessDeniedException;

    /**
     * Xbh擾܂BXbh݂ꍇACӂ̃XbhԂ܂B
     *
     * @return Xbh
     */
    Thread getThread();

    /**
     * w肵Xbh擾܂B null w肳ꂽꍇA{@link #getThread()} Ɠ
     * l̓܂B
     *
     * @param id Xbh ID
     * @return Xbh
     */
    Thread getThread(Integer id);

    /**
     * SẴXbh擾܂B
     *
     * @return Xbh̃Xg
     */
    List<Thread> getThreads();

    /**
     * R~jeBXgL̍ŏIXV̍~Ŏ擾܂BԂR~jeBɂ͍ŏIXV
     * ݒ肳ĂԂɂȂ܂B
     *
     * @param no Jnԍ
     * @param num 擾R~jeB̍ő吔
     * @return R~jeBXg
     */
    List<Thread> getThreadsOrderByLastUpdateDateDesc();

    /**
     * w肵Xbh폜܂B
     *
     * @param threadId Xbh ID
     * @throws CannotDeleteThreadException Xbh폜łȂ
     */
    void deleteThread(int threadId) throws CannotDeleteThreadException;

    Integer getId();

    void setId(Integer id);

    String getCode();

    void setCode(String code);

    Message getOverview();

    void setOverview(Message overview);

    Integer getOwnerId();

    void setOwnerId(Integer ownerId);

    AccessControl getReadAccessControl();

    void setReadAccessControl(AccessControl accessControl);

    AccessControl getWriteAccessControl();

    void setWriteAccessControl(AccessControl accessControl);

    AccessControl getPostAccessControl();

    void setPostAccessControl(AccessControl postAccessControl);

    /**
     * ŏIXV擾܂BR~jeB̊Tv̍XVł͂ȂAR~jeBێLȂǂX
     * VꂽԂ܂B
     *
     * @return ŏIXV
     */
    Date getLastUpdateDate();

    void setLastUpdateDate(Date lastUpdateDate);
}
