package org.unitedfront2.domain.communication;

import java.util.List;

import org.unitedfront2.dao.BlogDao;
import org.unitedfront2.domain.EmailForwarding;
import org.unitedfront2.domain.EmailForwardingTable;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.accesscontrol.AccessDeniedException;

/**
 * uÕe[uW[łB
 *
 * @author kurokkie
 *
 */
public class BlogTable {

    /** uOf[^ANZXIuWFNg */
    private BlogDao blogDao;

    /** e []ݒe[ug */
    private EmailForwardingTable emailForwardingTable;

    /**
     * uO擾܂B
     *
     * @param id ID
     * @return uOAȂ <code>null</code>
     */
    public Blog find(int id) {
        return blogDao.find(id);
    }

    /**
     * uOQƌŎ擾܂B
     *
     * @param id ID
     * @param user [U
     * @return uO
     * @throws AccessDeniedException ANZX
     */
    public Blog findForRead(int id, User user) throws AccessDeniedException {
        Blog blog = find(id);
        if (blog == null) {
            return null;
        } else {
            blog.readAccess(user);
            return blog;
        }
    }

    /**
     * uOҏWŎ擾܂B
     *
     * @param id ID
     * @param user [U
     * @return uO
     * @throws AccessDeniedException ANZX
     */
    public Blog findForWrite(int id, User user) throws AccessDeniedException {
        Blog blog = find(id);
        if (blog == null) {
            return null;
        } else {
            blog.writeAccess(user);
            return blog;
        }
    }

    /**
     * R[hw肵ăuO擾܂B
     *
     * @param code R[h
     * @return uOAȂ <code>null</code>
     */
    public Blog findByCode(String code) {
        return blogDao.findByCode(code);
    }

    /**
     * w肵R[huOQƌŎ擾܂B
     *
     * @param code R[h
     * @param user [U
     * @return uO
     * @throws AccessDeniedException ANZX
     */
    public Blog findByCodeForRead(String code, User user)
        throws AccessDeniedException {
        Blog blog = findByCode(code);
        if (blog == null) {
            return null;
        } else {
            blog.readAccess(user);
            return blog;
        }
    }

    /**
     * w肵R[huOҏWŎ擾܂B
     *
     * @param code R[h
     * @param user [U
     * @return uO
     * @throws AccessDeniedException ANZX
     */
    public Blog findByCodeForWrite(String code, User user)
        throws AccessDeniedException {
        Blog blog = findByCode(code);
        if (blog == null) {
            return null;
        } else {
            blog.writeAccess(user);
            return blog;
        }
    }

    /**
     * w肵L҂̃uOXg擾܂B
     *
     * @param ownerId L҂̃[U ID
     * @return uOXg
     */
    public List<Blog> findByOwnerId(int ownerId) {
        return blogDao.findByOwnerId(ownerId);
    }

    /**
     * [UɌJĂuO擾܂BԂl̃Xg͓o^̍~B
     *
     * @return uOXg
     */
    public List<Blog> findPublicBlogs() {
        return blogDao.findPublicBlogs();
    }

    /**
     * [UɌJĂuO擾܂B
     *
     * @param max ő匏
     * @return uOXg
     */
    public List<Blog> findPublicBlogsRandomly(int max) {
        return blogDao.findPublicBlogsRandomly(max);
    }

    /**
     * uORg e-[֓]ݒɂȂĂ邩ǂB
     *
     * @param userId [U ID
     * @return ]sݒɂȂĂꍇ <code>true</code> AȂĂȂȂ
     *     <code>false</code>
     */
    public boolean isBlogCommentForwarding(int userId) {
        return emailForwardingTable.find(userId, EmailForwarding.BLOG_COMMENT);
    }

    public void setBlogDao(BlogDao blogDao) {
        this.blogDao = blogDao;
    }

    public void setEmailForwardingTable(
            EmailForwardingTable emailForwardingTable) {
        this.emailForwardingTable = emailForwardingTable;
    }
}
