package org.unitedfront2.domain.communication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitedfront2.domain.DomainFactory;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.accesscontrol.AccessDeniedException;

/**
 * uOL̃t@NgNXłB
 *
 * @author kurokkie
 *
 */
public class BlogEntryTable {

    /** O */
    protected final Log logger = LogFactory.getLog(getClass());

    /** bZ[We[u */
    private MessageTable messageTable;

    /** hCt@Ng */
    private DomainFactory domainFactory;

    /**
     * uOL擾܂B
     *
     * @param id uOL ID
     * @return uOLAȂ <code>null</code>
     */
    public BlogEntry find(int id) {
        Message entry = messageTable.find(id);
        if (entry == null) {
            return null;
        }
        return domainFactory.prototype(new BlogEntry(entry), BlogEntry.class);
    }

    /**
     * uOLQƌŎ擾܂B
     *
     * @param id uOL ID
     * @param user [U
     * @return uOL
     * @throws AccessDeniedException ANZX
     */
    public BlogEntry findForRead(int id, User user)
        throws AccessDeniedException {
        BlogEntry entry = find(id);
        if (entry == null) {
            return null;
        } else {
            entry.readAccess(user);
            return entry;
        }
    }

    /**
     * uOLҏWŎ擾܂B
     *
     * @param id uOL ID
     * @param user [U
     * @return uOL
     * @throws AccessDeniedException ANZX
     */
    public BlogEntry findForWrite(int id, User user)
        throws AccessDeniedException {
        BlogEntry entry = find(id);
        if (entry == null) {
            return null;
        } else {
            entry.writeAccess(user);
            return entry;
        }
    }

    /**
     * w肵LR[huOL擾܂B
     *
     * @param code LR[hibZ[WR[hj
     * @return uOLAȂ <code>null</code>
     */
    public BlogEntry findByCode(String code) {
        Message entry = messageTable.findByCode(code);
        if (entry == null) {
            return null;
        }
        return domainFactory.prototype(new BlogEntry(entry), BlogEntry.class);
    }

    /**
     * w肵LR[huOLQƌŎ擾܂B
     *
     * @param id uOL ID
     * @param user [U
     * @return uOL
     * @throws AccessDeniedException ANZX
     */
    public BlogEntry findByCodeForRead(String code, User user)
        throws AccessDeniedException {
        BlogEntry entry = findByCode(code);
        if (entry == null) {
            return null;
        } else {
            entry.readAccess(user);
            return entry;
        }
    }

    /**
     * w肵LR[huOLҏWŎ擾܂B
     *
     * @param id uOL ID
     * @param user [U
     * @return uOL
     * @throws AccessDeniedException ANZX
     */
    public BlogEntry findByCodeForWrite(String code, User user)
        throws AccessDeniedException {
        BlogEntry entry = findByCode(code);
        if (entry == null) {
            return null;
        } else {
            entry.writeAccess(user);
            return entry;
        }
    }

    public void setMessageTable(MessageTable messageTable) {
        this.messageTable = messageTable;
    }

    public void setDomainFactory(DomainFactory domainFactory) {
        this.domainFactory = domainFactory;
    }
}
