package org.unitedfront2.dao.jdbc;

import javax.sql.DataSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.util.Assert;

/**
 * DAO ̎ɂċʓIɗp@\񋟂钊ۃNXłBʂȗRȂADAO ̎
 * ͂̃NXpĂBTuNX {@link JdbcTemplate}@A
 * {@link NamedParameterJdbcTemplate} A{@link SimpleJdbcTemplate} A
 * {@link SimpleJdbcInsert} 𗘗pł܂B́AANZX_ŃvpeBɒlݒ肳
 * ܂iCW[[hjBA{@link SimpleJdbcInsert} ́ATuNX
 * {@link #createSimpleJdbcInsert(DataSource)} 𐳂ĂȂΗpł܂B
 *
 * @author kurokkie
 *
 */
abstract class DaoSupport implements InitializingBean {

    /** O */
    protected final Log logger = LogFactory.getLog(getClass());

    /** f[^\[X */
    @Autowired private DataSource dataSource;

    /** {@link JdbcTemplate} */
    private JdbcTemplate jdbcTemplate;

    /** {@link NamedParameterJdbcTemplate} */
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    /** {@link SimpleJdbcTemplate} */
    private SimpleJdbcTemplate simpleJdbcTemplate;

    /** {@link SimpleJdbcInsert} */
    private SimpleJdbcInsert simpleJdbcInsert;

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull(dataSource);
    }

    /**
     *  DAO ŗp {@link SimpleJdbcInsert} 𐶐܂B̎ null ԂĂ
     * ܂B{@link SimpleJdbcInsert} 𗘗pꍇ̓TuNXł̃\bhI[o[ChĂ
     * B
     *
     * @param dataSource {@link DataSource}
     * @return {@link SimpleJdbcInsert}
     */
    protected SimpleJdbcInsert createSimpleJdbcInsert(DataSource dataSource) {
        return null;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected JdbcTemplate getJdbcTemplate() {
        if (jdbcTemplate == null) {
            jdbcTemplate = new JdbcTemplate(dataSource);
        }
        return jdbcTemplate;
    }

    protected NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        if (namedParameterJdbcTemplate == null) {
            namedParameterJdbcTemplate
                = new NamedParameterJdbcTemplate(dataSource);
        }
        return namedParameterJdbcTemplate;
    }

    protected SimpleJdbcTemplate getSimpleJdbcTemplate() {
        if (simpleJdbcTemplate == null) {
            simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
        }
        return simpleJdbcTemplate;
    }

    /**
     * {@link SimpleJdbcInsert} 擾܂BTuNX
     * {@link #createSimpleJdbcInsert(DataSource)} 𐳂I[o[ChĂȂꍇA
     * ̃\bhĂяo͎sA{@link UnsupportedOperationException} ܂B
     *
     * @return {@link SimpleJdbcInsert}
     * @throws UnsupportedOperationException
     *     {@link #createSimpleJdbcInsert(DataSource)} ĂȂ\
     *     ܂B
     */
    protected SimpleJdbcInsert getSimpleJdbcInsert()
        throws UnsupportedOperationException {

        if (simpleJdbcInsert == null) {
            simpleJdbcInsert = createSimpleJdbcInsert(dataSource);
        }

        if (simpleJdbcInsert == null) {
            String message = "The SimleJdbcInsert unavailable. If you need to "
                + "use it, you must override 'createSimpleJdbcInsert' method.";
            logger.error(message);
            throw new UnsupportedOperationException(message);
        }
        return simpleJdbcInsert;
    }
}
