package org.unitedfront2.dao;

import java.util.Set;

import org.unitedfront2.domain.SimpleUser;

/**
 * FB\݃f[^ANZXC^[tF[XłB
 *
 * @author kurokkie
 *
 */
public interface FriendSubscriptionDao {

    /**
     * FB\݂o^܂B
     *
     * @param fromId \݌̃[U ID
     * @param toId \ݐ̃[U ID
     * @require ${fromId} exists.
     * @require ${fromId} != ${toId}
     * @require ${this.find(fromId, toId)} is null.
     * @ensure ${this.find(fromId, toId)} not null.
     */
    void register(int fromId, int toId);

    /**
     * [U ${toId} [U ${fromId} FB\݂󂯕tĂ邩ǂ𔻒肵A󂯕t
     * Ă ${fromId} ̃[UIuWFNgԂ܂B
     *
     * @param toId FB\݂󂯂[U ID
     * @param fromId FB\݂s[U ID
     * @return FB\݂s[UA\݂ĂȂ <code>null</code>
     */
    SimpleUser find(int toId, int fromId);

    /**
     * ${fromId} ɗFB\݂s[UZbg擾܂B
     *
     * @param fromId [U ID
     * @return FBZbg
     */
    Set<SimpleUser> findByFromId(int fromId);

    /**
     * ${toId} ̗FB\ݐ̃[UZbg擾܂B
     *
     * @param toId [U ID
     * @return FBZbg
     */
    Set<SimpleUser> findByToId(int toId);

    /**
     * FB\݂폜܂B
     *
     * @param fromId [U ID
     * @param toId FB̃[U ID
     * @require ${fromId} exists.
     * @require ${toId} exists.
     * @ensure ${this.find(fromId, toId)} not null.
     * @ensure ${this.find(fromId, toId)} is null.
     */
    void delete(int fromId, int toId);
}
