package org.unitedfront2.domain.communication;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.dao.SimpleFindable;
import org.unitedfront2.domain.SimpleTableModule;
import org.unitedfront2.domain.accesscontrol.AuthorOnly;
import org.unitedfront2.domain.accesscontrol.Public;
import org.unitedfront2.test.TableModuleTestCaseSupport;

public class MessageTableTest extends TableModuleTestCaseSupport<Message> {

    @Autowired private MessageTable messageTable;

    @Override
    protected Message createDomain() {
        Message message = domainFactory.prototype(Message.class);
        message.setAuthorId(simpleUser1.getId());
        Map<Locale, MessageEntry> entryMap = new HashMap<Locale, MessageEntry>();
        MessageEntry entry_ja = new MessageEntry();
        entry_ja.setSubject("Tv^Cg");
        entry_ja.setBody("Tv{");
        MessageEntry entry_en = new MessageEntry();
        entry_en.setSubject("sample title");
        entry_en.setBody("sample body");
        entryMap.put(Locale.JAPANESE, entry_ja);
        entryMap.put(Locale.ENGLISH, entry_en);
        message.setEntryMap(entryMap);
        message.setOwnerId(simpleUser1.getId());
        message.setReadAccessControl(domainFactory.prototype(Public.class));
        message.setWriteAccessControl(domainFactory.prototype(AuthorOnly.class));
        return message;
    }

    @Override
    protected SimpleTableModule<Message> getTableModule() {
        return messageTable;
    }

    @Override
    protected SimpleFindable<Message> getSimpleDao() {
        return messageTable.getSimpleDao();
    }
}
