<%@ page language="java" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/view/Include.jsp" %>

<div>
  <h2><spring:message code="${pageTitleCode}"/></h2>
  <c:if test="${not empty pageDescriptionCode}">
    <p><spring:message code="${pageDescriptionCode}"/></p>
  </c:if>
  <form:form commandName="mail">
    <input type="hidden" name="_eventId" value="submit"/>
    <input type="hidden" name="_flowExecutionKey" value="${flowExecutionKey}"/>
    <c:if test="${empty unmodifiableTo}">
    <div class="element">
      * <spring:message code="mail.to"/>: <form:errors path="to.name" cssClass="errors"/><br/>
      <form:input path="to.name" id="mail.CreateForm.to.name"/>
    </div>
    </c:if>
    <div class="element">
      <spring:message code="subject"/>: <form:errors path="subject" cssClass="errors"/><br/>
      <form:input path="subject" id="mail.CreateForm.subject" maxlength="${validator.subjectMaxLength}"/> ( <spring:message code="validation.Validate.maxLength" arguments="${validator.subjectMaxLength}"/> )
    </div>
    <div class="element">
      <spring:message code="body"/>: <form:errors path="body" cssClass="errors"/><br/>
      <form:textarea path="body" rows="5" cols="40" id="mail.CreateForm.body"/>
    </div>
    <div class="element">
      <input type="submit" value="<spring:message code="${formSubmitCode}"/>" class="button" onclick="this.disabled='disabled';this.form.submit();"/>
    </div>
  </form:form>
</div>
<uf2:script>
  <c:choose>
    <c:when test="${empty mail.to or empty mail.to.name}">
      document.getElementById('mail.CreateForm.to.name').focus();
    </c:when>
    <c:when test="${empty mail.subject}">
      document.getElementById('mail.CreateForm.subject').focus();
    </c:when>
    <c:otherwise>
      document.getElementById('mail.CreateForm.body').focus();
    </c:otherwise>
  </c:choose>
  <spring:bind path="mail.to.name">
    <c:if test="${status.error}">
      document.getElementById('mail.CreateForm.to.name').focus();
    </c:if>
  </spring:bind>
</uf2:script>
