package org.unitedfront2.web.controller.profile;

import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.Account.Role;
import org.unitedfront2.domain.AccountTable;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.communication.Footmark;
import org.unitedfront2.domain.communication.Profile;
import org.unitedfront2.domain.communication.ProfileTable;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.flow.AccessDeniedException;
import org.unitedfront2.web.flow.PageNotFoundException;
import org.unitedfront2.web.handler.TitleInterceptor;

/**
 * vtB[\SANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "profile.viewAction")
public class ViewAction extends AbstractAction {

    /** AJEge[u */
    @Autowired private AccountTable accountTable;

    /** vtB[e[u */
    @Autowired private ProfileTable profileTable;

    /** ŐVLƂ錏 (3) */
    private static final int LATEST_ARTICLE_COUNT = 3;

    /**
     * NGXgꂽ[UR[hvtB[擾܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     * @throws PageNotFoundException vtB[݂Ȃ
     * @throws AccessDeniedException ANZX
     */
    @Override
    protected Event doExecute(RequestContext context)
        throws PageNotFoundException, AccessDeniedException {

        String userCode = context.getRequestParameters().get("userCode");
        User user = WebUtils.findUser(context);
        Profile profile;
        try {
            profile = findByUserCode(userCode, user);
        } catch (
            org.unitedfront2.domain.accesscontrol.AccessDeniedException e) {
            String message = "The user '" + user
                + "' cannot access to the user [" + userCode + "]'s profile.";
            logger.warn(message);
            throw new AccessDeniedException(context, this, message, e);
        }
        if (profile == null) {
            String message = "Profile not found. [User Code: '"
                + userCode + "']";
            logger.warn(message);
            throw new PageNotFoundException(context, this, message);
        }

        retrieve(profile, context);

        context.getRequestScope().put(TitleInterceptor.TITLE_ARGS_PARAM_NAME,
                new Object[] {profile.getOwner().getName()});
        context.getRequestScope().put("profile", profile);

        return success();
    }

    private void retrieve(Profile profile, RequestContext context) {
        String userCode = context.getRequestParameters().get("userCode");
        User user = WebUtils.findUser(context);

        // LҏƎȏЉ
        profile.retrieveOwner();
        profile.retrieveSelfIntroduction();

        // uO
        profile.retrieveBlogs(user);
        profile.retrieveBlogEntries(0, LATEST_ARTICLE_COUNT);

        // FB
        profile.retrieveProfileOfFriends();

        // FB\
        if (user != null) {
            // [UłȂȂFB\ݏ󋵂𕜌
            profile.retrieveSubscriptingUsers();
            if (user.getCode().equals(userCode)) {
                // ̃vtB[ȂAvtB[𕜌ivtB[N̐̂߁j
                for (SimpleUser u : profile.getSubscriptingUsers()) {
                    u.retrieveProfile();
                }
            }
        }

        // 
        if (user != null && user.getCode().equals(userCode)) {
            // ̃vtB[ȂAՂ𕜌
            profile.retrieveFootmarks();

            // IɑSĂ̑Ղ̃[UvtB[𕜌
            Map<User, Profile> map = new HashMap<User, Profile>();
            for (Footmark f : profile.getFootmarks()) {
                if (map.containsKey(f.getUser())) {
                    f.getUser().setProfile(map.get(f.getUser()));
                } else {
                    f.getUser().retrieveProfile();
                    map.put(f.getUser(), f.getUser().getProfile());
                }
            }
        }
    }

    private Profile findByUserCode(String userCode, User user)
        throws org.unitedfront2.domain.accesscontrol.AccessDeniedException {

        Profile profile = profileTable.findByOwnerCode(userCode);
        if (profile == null) {
            return null;
        }
        access(profile, user);
        return profile;
    }

    private void access(Profile profile, User user)
        throws org.unitedfront2.domain.accesscontrol.AccessDeniedException {
        profile.readAccess(user);
        footmark(profile, user);
    }

    private void footmark(Profile profile, User user) {
        if (user != null && !user.equals(profile.getOwner())) {
            Account account = accountTable.get(user.getId());
            if (!account.getRoles().contains(Role.ROLE_ADMIN)) {
                profile.footmark(user.getId());
            }
        }
    }
}
