package org.unitedfront2.web.controller.profile;

import java.util.List;

import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.preparer.PreparerException;
import org.apache.tiles.preparer.ViewPreparer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.communication.Profile;
import org.unitedfront2.domain.communication.ProfileTable;
import org.unitedfront2.web.WebUtils;

/**
 * FBEBWFbg {@link ViewPreparer} łB
 *
 * @author kurokkie
 *
 */
@Repository(value = "profile.friendWidgetPreparer")
public class FriendWidgetPreparer implements ViewPreparer {

    /** FBXg̍ő吔 (10) */
    public static final int MAX_FRIENDS_SIZE = 10;

    /** vtB[e[u */
    @Autowired private ProfileTable profileTable;

    @Override
    public void execute(TilesRequestContext tilesContext,
            AttributeContext attributeContext) throws PreparerException {
        User user = WebUtils.getUser(tilesContext);
        Profile profile = profileTable.get(user.getId());
        profile.retrieveFriends(MAX_FRIENDS_SIZE);
        List<SimpleUser> friends = profile.getFriends();
        SimpleUser.retrieveProfiles(friends);
        attributeContext.putAttribute("friends", new Attribute(friends));
    }
}
