package org.unitedfront2.web.controller.profile;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.accesscontrol.AccessControl;
import org.unitedfront2.domain.communication.Profile;
import org.unitedfront2.domain.communication.ProfileTable;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.controller.SubflowUtils;
import org.unitedfront2.web.controller.accesscontrol.FormAction;

/**
 * ANZX̕ύXSANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "profile.accessControlUpdateAction")
public class AccessControlUpdateAction extends MultiAction {

    /** vtB[e[u */
    @Autowired private ProfileTable profileTable;

    /**
     * ݂̃ANZXt[XR[vɐݒ肵܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     */
    public Event init(RequestContext context) {
        Account account = WebUtils.findAccount(context);
        Profile profile = profileTable.get(account.getId());
        profile.retrieveOwner();
        context.getFlowScope().put("profile", profile);
        context.getFlowScope().put(SubflowUtils.FORM_SUBMIT_CODE_PARAM_NAME,
                "doUpdate");
        return success();
    }

    /**
     * ANZXۑ܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     */
    public Event store(RequestContext context) {
        AccessControl accessControl = (AccessControl)
            context.getFlowScope().get(FormAction.ACCESS_CONTROL_PARAM_NAME);
        accessControl.store();
        return success();
    }
}
