package org.unitedfront2.web.controller.community;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.validation.Errors;
import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.domain.communication.CommunityValidator;
import org.unitedfront2.validation.SpringValidatorSupport;
import org.unitedfront2.validation.ValidationException;

/**
 * R~jeB쐬/ҏW̓͒l؃NXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "community.formValidator")
public class FormValidator
    extends SpringValidatorSupport<CommunityValidator, Community> {

    @Override
    protected void doValidate(Community community, Errors errors) {
        try {
            getOriginalValidator().validateCode(community);
        } catch (ValidationException e) {
            rejectValue("code", e, errors);
        }
    }

    @Override
    @Autowired
    public void setOriginalValidator(CommunityValidator originalValidator) {
        super.setOriginalValidator(originalValidator);
    }
}
