package org.unitedfront2.web.controller.blog;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.BlogEntry;
import org.unitedfront2.domain.communication.BlogEntryTable;

/**
 * uOL폜p̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "blog.entryDeleteAction")
public class EntryDeleteAction extends AbstractAction {

    /** uOLe[u */
    @Autowired private BlogEntryTable blogEntryTable;

    @Override
    protected Event doExecute(RequestContext context) throws Exception {

        // uOL擾
        BlogEntry entry = Utils.findAndReadAccessByCode(context, this,
                blogEntryTable, "entryCode");
        entry.delete();

        String blogCode = context.getRequestParameters().getRequired(
            "blogCode");
        context.getFlowScope().put("blogCode", blogCode);

        return success();
    }
}
