package org.unitedfront2.web.controller.accesscontrol;

import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.accesscontrol.AccessControl;
import org.unitedfront2.web.controller.SubflowUtils;
import org.unitedfront2.web.flow.BadRequestException;

/**
 * ANZXXVʂ̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "accesscontrol.formAction")
public class FormAction extends MultiAction {

    /** t[XR[vɐݒ肷ANZXIuWFNg̕ϐ (accessControl) */
    public static final String ACCESS_CONTROL_PARAM_NAME = "accessControl";

    /** ANZXpbP[W */
    private static final String ACCESS_CONTROL_PACKAGE
        = "org.unitedfront2.domain.accesscontrol";

    /**
     * tH[\Ȍs܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event setupForm(RequestContext context) {
        SubflowUtils.setupMessages(context, "accesscontrol.Form",
                "accesscontrol.Form.description");
        context.getRequestScope().put(ACCESS_CONTROL_PARAM_NAME,
                context.getFlowScope().get(ACCESS_CONTROL_PARAM_NAME));
        return success();
    }

    /**
     * oChƓ͒l؂s܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     * @throws BadRequestException sȃANZX^CvMꂽ
     */
    public Event bindAndValidate(RequestContext context)
        throws BadRequestException {

        if (context.getFlowScope()
                .get(ACCESS_CONTROL_PARAM_NAME) == null) {
            // t[Ɍs̃ANZXIuWFNgݒ肳ĂȂ
            String message = "The current access control object must be set.";
            logger.error(message);
            throw new IllegalStateException(message);
        }

        try {
            doValidate(context);
        } catch (IllegalArgumentException e) {
            logger.warn(e.getMessage());
            context.getRequestScope().put("exception", e);
        }
        doBind(context);
        return success();
    }

    private void doValidate(RequestContext context)
        throws BadRequestException {

        String requestedAccessControlType = context.getRequestParameters()
            .get("accessControlType");

        Class<? extends AccessControl> clazz;
        try {
            clazz = (Class<? extends AccessControl>) Class.forName(
                    ACCESS_CONTROL_PACKAGE + "."
                    + requestedAccessControlType);
        } catch (ClassNotFoundException e) {
            String message = "The requested access control type '"
                + requestedAccessControlType + "' not found.";
            logger.warn(message);
            throw new BadRequestException(context, this, message, e);
        }
        if (!AccessControl.class.isAssignableFrom(clazz)) {
            String message = "The requested access control type '"
                + requestedAccessControlType + "' not found.";
            logger.warn(message);
            throw new BadRequestException(context, this, message);
        }
    }

    private void doBind(RequestContext context) {
        String requestedAccessControlType = context.getRequestParameters()
            .get("accessControlType");
        Class<? extends AccessControl> clazz;
        try {
            clazz = (Class<? extends AccessControl>) Class.forName(
                    ACCESS_CONTROL_PACKAGE + "."
                    + requestedAccessControlType);
        } catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), e);
            throw new IllegalStateException(e);
        }
        AccessControl current = (AccessControl)
            context.getFlowScope().get(ACCESS_CONTROL_PARAM_NAME);
        current.changeTo(clazz);
    }
}
