package org.unitedfront2.web.controller;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.Blog;
import org.unitedfront2.domain.communication.BlogEntry;
import org.unitedfront2.domain.communication.BlogTable;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.MessageTable;
import org.unitedfront2.web.WebUtils;

/**
 * CfbNXʂ̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "indexAction")
public class IndexAction extends AbstractAction {

    /** gbvy[WXVԊu (15) */
    public static final int REFLESH_TERM = 60 * 15 * 1000;

    /** Ǘ҃uO̕\L */
    public static final int ADMIN_BLOG_ENTRY_DISPLAY_NUM = 5;

    /** OXV */
    private Date lastRefleshDate;

    /** gbvy[W */
    private Message topPage;

    /** Ǘ҃uO */
    private Blog adminBlog;

    /** Ǘ҂̃uOR[h */
    private String adminBlogCode;

    /** bZ[We[u */
    @Autowired
    private MessageTable messageTable;

    /** uOe[u */
    @Autowired
    private BlogTable blogTable;

    @Override
    protected Event doExecute(RequestContext context) {
        if (topPage == null || adminBlog == null
                || new Date().after(new Date(lastRefleshDate.getTime()
                        + REFLESH_TERM))) {
            update();
        }
        context.getRequestScope().put("topPage", topPage);
        context.getRequestScope().put("adminBlog", adminBlog);
        context.getRequestScope().put("_feedUrl", "/index.xml");
        return success();
    }

    private void update() {
        topPage = messageTable.getByCode(WebUtils.TOP_PAGE_MESSAGE_CODE);

        adminBlog = blogTable.getByCode(adminBlogCode);
        adminBlog.retrieveEntries(0, ADMIN_BLOG_ENTRY_DISPLAY_NUM);

        // Rg̕
        for (BlogEntry entry : adminBlog.getEntries()) {
            entry.retrieveCommentCount();
        }

        // L҂̕
        adminBlog.retrieveOwner();
        adminBlog.getOwner().retrieveProfile();

        lastRefleshDate = new Date();
    }

    public void setAdminBlogCode(String adminBlogCode) {
        this.adminBlogCode = adminBlogCode;
    }
}
