package org.unitedfront2.web.controller;

import com.octo.captcha.service.CaptchaServiceException;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitedfront2.util.CaptchaServiceSingleton;

/**
 * CAPTCHA ̉摜o͂T[ubgłBCAPTCHA  Completely Automated Public
 * Turing Test to Tell Computers and Humans Apart ̗łB̃T[ubǵARs[^
 * Ɛl𔻕ʂ邽߂̉摜o͂܂B
 *
 * @author kurokkie
 *
 */
public class ImageCaptchaServlet extends HttpServlet {

    /** O */
    protected final transient Log logger = LogFactory.getLog(getClass());

    /**@VAԍ */
    private static final long serialVersionUID = 2311704194108629188L;

    @Override
    protected void doGet(HttpServletRequest httpServletRequest,
            HttpServletResponse httpServletResponse) throws ServletException,
            IOException {
        byte[] captchaChallengeAsJpeg = null;
        // the output stream to render the captcha image as jpeg into
        ByteArrayOutputStream jpegOutputStream = new ByteArrayOutputStream();
        try {
            // get the session id that will identify the generated captcha.
            // the same id must be used to validate the response, the session
            // id is a good candidate!
            String captchaId = httpServletRequest.getSession().getId();
            // call the ImageCaptchaService getChallenge method
            BufferedImage challenge = CaptchaServiceSingleton.getInstance()
                .getImageChallengeForID(captchaId,
                        httpServletRequest.getLocale());

            // a jpeg encoder
            ImageIO.write(challenge, "jpeg", jpegOutputStream);
        } catch (IllegalArgumentException e) {
            logger.error(e.getMessage(), e);
            httpServletResponse.sendError(HttpServletResponse.SC_NOT_FOUND);
            throw new ServletException(e);
        } catch (CaptchaServiceException e) {
            logger.error(e.getMessage(), e);
            httpServletResponse.sendError(
                    HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
            throw new ServletException(e);
        }

        captchaChallengeAsJpeg = jpegOutputStream.toByteArray();

        // flush it in the response
        httpServletResponse.setHeader("Cache-Control", "no-store");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setDateHeader("Expires", 0);
        httpServletResponse.setContentType("image/jpeg");
        ServletOutputStream responseOutputStream =
                httpServletResponse.getOutputStream();
        responseOutputStream.write(captchaChallengeAsJpeg);
        responseOutputStream.flush();
        responseOutputStream.close();
    }
}
