package org.unitedfront2.domain.communication;

import java.util.Date;

import org.unitedfront2.domain.Deletable;
import org.unitedfront2.domain.Domain;
import org.unitedfront2.domain.Identifiable;
import org.unitedfront2.domain.Storable;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.accesscontrol.AccessControl;
import org.unitedfront2.domain.accesscontrol.AccessDeniedException;
import org.unitedfront2.domain.accesscontrol.Resource;

/**
 * R~jeB\C^[tF[XłB
 *
 * <div><img src="doc-files/Community.png" alt="NX}"/></div>
 *
 * @invariant ${this.ownerId} is ${this.overview.ownerId}
 * @invariant ${this.overview.authorId} is ${this.overview.ownerId}
 * @invariant ${this.readAccessControl} equals
 * ${this.overview.readAccessControl}
 * @invariant ${this.writeAccessControl} equals
 * ${this.overview.writeAccessControl}
 * @invariant ${this.writeAccessControl.type} is
 * {@link org.unitedfront2.domain.accesscontrol.OwnerOnly}
 *
 * @author kurokkie
 *
 */
public interface Community extends Resource, Identifiable<Community>, Storable,
    Deletable, Domain {

    /**
     * ҏW͕K {@link org.unitedfront2.domain.accesscontrol.OwnerOnly} 
     * 肳܂BR[hdĂȂǂmFAdĂ
     * {@link CommunityCodeUsedByOtherException} 𔭐܂BVKo^ɂ͏L҂̃}
     * CR~jeBɂ̃R~jeBǉ܂B܂AXVɎQƌ[ÚAIɃR
     * ~jeBމs܂B
     */
    @Override
    void store() throws CommunityCodeUsedByOtherException;

    /**
     * @throws CannotDeleteCommunityException R~jeB폜łȂ
     */
    @Override
    void delete() throws CannotDeleteCommunityException;

    /**
     * R~jeB̃^CvύXR~jeBԂ܂BvpeB́Ap邾p܂BύX
     * sꍇ {@link CannotChangeCommunityException} ܂BύXɐ
     * ǂ {@link #canChangeTo(Class)} \bhŊm߂邱Ƃł܂B
     *
     * @param <C> R~jeB
     * @param clazz R~jeBNX
     * @return ύX̐VR~jeB
     * @throws CannotChangeCommunityException ^Cv̕ύXɎs
     */
    <C extends Community> C changeTo(Class<C> clazz)
        throws CannotChangeCommunityException;

    /**
     * w肵R~jeBɕύX\ǂ𔻒肵܂B
     *
     * @param <C> R~jeB
     * @param clazz R~jeBNX
     * @return ύX\Ȃ <code>true</code> As\Ȃ <code>false</code>
     */
    <C extends Community> boolean canChangeTo(Class<C> clazz);

    /**
     * ̃R~jeBɎQł邩ǂ𔻒肵܂B
     *
     * @return QȂ <code>true</code> AłȂȂ <code>false</code>
     */
    boolean isMyCommunity();

    /**
     * {@link #isMyCommunity()} \bhLɂ܂B
     *
     * @param user [U
     */
    void retrieveMyCommunity(User user);

    /**
     * L҂𕜌܂B
     */
    void retrieveOwner();

    /**
     * ̃R~jeBɎQ܂B
     *
     * @param userId [U ID
     * @throws CannotEntryCommunityException ɂ̃R~jeBɎQĂ
     */
    void entry(int userId) throws CannotEntryCommunityException;

    /**
     * ̃R~jeBɎQ܂B
     *
     * @param user [U
     * @throws CannotEntryCommunityException ɂ̃R~jeBɎQĂ
     */
    void entry(User user) throws CannotEntryCommunityException;

    /**
     * ̃R~jeBމ܂B
     *
     * @param userId [U ID
     * @throws CannotCancelCommunityException L҂Ȃ̂őމłȂA܂͉łȂ
     */
    void cancel(int userId) throws CannotCancelCommunityException;

    /**
     * ̃R~jeBމ܂B
     *
     * @param user [U
     * @throws CannotCancelCommunityException L҂Ȃ̂őމłȂA܂͉łȂ
     */
    void cancel(User user) throws CannotCancelCommunityException;

    /**
     * 폜\ł邩ǂ𔻒肵܂B̃\bh <code>true</code> ԂꍇAf[^̐
     * Ɉᔽ邱ƂȂ̃R~jeB폜ł܂B
     *
     * @return 폜\ł <code>true</code> AłȂ <code>false</code>
     */
    boolean isDeletable();

    /**
     * [UœeANZX݂܂B
     *
     * @throws AccessDeniedException ANZX
     */
    void postAccess() throws AccessDeniedException;

    /**
     * eANZX݂܂B
     *
     * @param userId [U ID
     * @throws AccessDeniedException ANZX
     */
    void postAccess(int userId) throws AccessDeniedException;

    /**
     * eANZX݂܂B${user}  <code>null</code> łΓ[UƂ݂Ȃ܂B
     *
     * @param user [U
     * @throws AccessDeniedException ANZX
     */
    void postAccess(User user) throws AccessDeniedException;

    /**
     * [UɓeANZX邩肵܂B
     *
     * @return  <code>true</code> AȂ <code>false</code>
     */
    boolean canPost();

    /**
     * eANZX邩肵܂B${user}  <code>null</code> łΓ[UƂ
     * Ȃ܂B
     *
     * @param userId [U ID
     * @return  <code>true</code> AȂ <code>false</code>
     */
    boolean canPost(int userId);

    /**
     * eANZX邩肵܂B
     *
     * @param user [U
     * @return  <code>true</code> AȂ <code>false</code>
     */
    boolean canPost(User user);

    /**
     * ŏIXV𕜌܂B
     */
    void retrieveLastUpdateDate();

    Integer getId();

    void setId(Integer id);

    String getCode();

    void setCode(String code);

    Message getOverview();

    void setOverview(Message overview);

    Integer getOwnerId();

    void setOwnerId(Integer ownerId);

    AccessControl getReadAccessControl();

    void setReadAccessControl(AccessControl accessControl);

    AccessControl getWriteAccessControl();

    void setWriteAccessControl(AccessControl accessControl);

    AccessControl getPostAccessControl();

    void setPostAccessControl(AccessControl postAccessControl);

    /**
     * ŏIXV擾܂BR~jeB̊Tv̍XVł͂ȂAR~jeBێLȂǂX
     * VꂽԂ܂B{@link #retrieveLastUpdateDate()} ĂяoAp\ɂ
     * ܂B
     *
     * @return ŏIXV
     */
    Date getLastUpdateDate();

    void setLastUpdateDate(Date lastUpdateDate);
}
