package org.unitedfront2.domain.accesscontrol;

import org.unitedfront2.domain.User;

/**
 * ANZX̑ΏۂƂȂ鎑̃C^[tF[XłB
 *
 * @author kurokkie
 *
 * @see org.unitedfront2.domain.accesscontrol.AccessControl
 */
public interface Resource {

    /**
     * L҂̃[U ID 擾܂B
     *
     * @return L҂̃[U ID
     */
    Integer getOwnerId();

    /**
     * [UɎQƌ邩ǂ肵܂B
     *
     * @throws AccessDeniedException ANZX
     */
    void readAccess() throws AccessDeniedException;

    /**
     * [UɎQƌ邩ǂ肵܂B
     *
     * @return Qƌ <code>true</code> AȂ <code>false</code>
     */
    boolean canRead();

    /**
     * [UɎQƌ邩ǂ肵܂B
     *
     * @param userId [U ID
     * @throws AccessDeniedException ANZX
     */
    void readAccess(int userId) throws AccessDeniedException;

    /**
     * [UɎQƌ邩ǂ肵܂B
     *
     * @param userId [U ID
     * @return Qƌ <code>true</code> AȂ <code>false</code>
     */
    boolean canRead(int userId);

    /**
     * [UɎQƌ邩ǂ肵܂B${user}  <code>null</code> łΓ[
     * UƂ݂Ȃ܂B
     *
     * @param user [U
     * @return Qƌ <code>true</code> AȂ <code>false</code>
     */
    boolean canRead(User user);

    /**
     * [UɎQƌ邩ǂ肵܂B${user}  <code>null</code> łΓ[
     * UƂ݂Ȃ܂B
     *
     * @param user [U
     * @throws AccessDeniedException ANZX
     */
    void readAccess(User user) throws AccessDeniedException;

    /**
     * [UɕҏW邩ǂ肵܂B
     *
     * @throws AccessDeniedException ANZX
     */
    void writeAccess() throws AccessDeniedException;

    /**
     * [UɕҏW邩ǂ肵܂B
     *
     * @return ҏW <code>true</code> AȂ <code>false</code>
     */
    boolean canWrite();

    /**
     * [UɕҏW邩ǂ肵܂B
     *
     * @param userId [U ID
     * @throws AccessDeniedException ANZX
     */
    void writeAccess(int userId) throws AccessDeniedException;

    /**
     * [UɕҏW邩ǂ肵܂B
     *
     * @param userId [U ID
     * @return ҏW <code>true</code> AȂ <code>false</code>
     */
    boolean canWrite(int userId);

    /**
     * [UɕҏW邩ǂ肵܂B${user}  <code>null</code> łΓ[
     * UƂ݂Ȃ܂B
     *
     * @param user [U
     * @throws AccessDeniedException ANZX
     */
    void writeAccess(User user) throws AccessDeniedException;

    /**
     * [UɕҏW邩ǂ肵܂B${user}  <code>null</code> łΓ[
     * UƂ݂Ȃ܂B
     *
     * @param user [U
     * @return ҏW <code>true</code> AȂ <code>false</code>
     */
    boolean canWrite(User user);
}
