package org.unitedfront2.dao;

import java.util.List;

import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.Thread;

/**
 * Xbh̃f[^ANZXC^[tF[XłB
 *
 * @author kurokkie
 *
 */
public interface ThreadDao extends Registerable<Thread>, SimpleFindable<Thread>,
    Updatable<Thread>, SimpleDeletable, Dao {

    /**
     * ${thread.overview.ownerId} ɂ ${thread.ownerId} ݒ肳܂B
     * ${thread.overview.authorId} ɂ ${thread.ownerId} ݒ肳܂B
     * ${thread.overview.readAccessControl} ɂ ${thread.readAccessControl} 
     * 肳܂B${thread.overview.writeAccessControl} ɂ
     * ${thread.writeAccessControl} ݒ肳܂B
     */
    @Override
    void register(Thread thread);

    /**
     * w肵XbhɎw肵Lo^܂B
     *
     * @param id Xbh ID
     * @param entryId uOL ID ibZ[W IDj
     */
    void registerEntry(int id, int entryId);

    /**
     * w肵Xbh ID ƃbZ[W ID LԂ܂BႦ݂郁bZ[WłĂAw肵
     * XbhɏĂȂ <code>null</code> Ԃ܂B
     *
     * @param threadId Xbh ID
     * @param entryId bZ[W ID
     * @return L
     */
    Message findEntry(int threadId, int entryId);

    /**
     * w肵͈͂̃uOL擾܂B
     *
     * @param id Xbh ID
     * @return LXg
     */
    List<Message> findEntries(int id);

    /**
     * w肵͈͂̃uOL擾܂BLԍ͂On܂鐮ŁAID ̍~ɂȂ܂B
     *
     * @param id Xbh ID
     * @param no Jn_ƂȂLԍ
     * @param num 
     * @return LXg
     */
    List<Message> findEntries(int id, int no, int num);

    /**
     * XbhL̐擾܂B
     *
     * @param id Xbh ID
     * @return L
     */
    int countEntry(int id);

    /**
     * ${thread.overview.ownerId} ɂ ${thread.ownerId} ݒ肳܂B
     * ${thread.overview.authorId} ɂ ${thread.ownerId} ݒ肳܂B
     * ${thread.overview.readAccessControl} ɂ ${thread.readAccessControl} 
     * 肳܂B${thread.overview.writeAccessControl} ɂ
     * ${thread.writeAccessControl} ݒ肳܂B
     */
    @Override
    void update(Thread thread);

    /**
     * TvANZX͋L\邽ߍ폜܂BKvɉč폜 API Ăяo
     * ĂB
     */
    @Override
    void delete(int id);
}
