package org.unitedfront2.dao;

import java.util.List;

import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.domain.communication.Thread;

/**
 * R~jeBf[^ANZXC^[tF[XłB
 *
 * @author kurokkie
 *
 */
public interface CommunityDao extends Registerable<Community>,
    SimpleFindable<Community>, Updatable<Community>, SimpleDeletable, Dao {

    /**
     * ${this.ownerId}  ${this.overview.ownerId} 
     * ${this.overview.authroId} ɐݒ肵܂B${this.readAccessControl} 
     * ${this.overview.readAccessControl} ɐݒ肵܂B${this.writeAccessControl}
     *  ${this.overview.writeAccessControl} ɐݒ肵܂B
     */
    @Override
    void register(Community community);

    /**
     * R~jeBɃXbh蓖Ă܂B
     *
     * @param id R~jeB ID
     * @param threadId Xbh ID
     */
    void registerThread(int id, int threadId);

    /**
     * R~jeBXgL̍ŏIXV̍~Ŏ擾܂BԂR~jeBɂ͍ŏIXV
     * 肳ĂԂɂȂ܂B
     *
     * @param no Jnԍ
     * @param num 擾R~jeB̍ő吔
     * @return R~jeBXg
     */
    List<Community> findOrderByLastUpdateDateDesc(int no, int num);

    /**
     * R[hw肵ăR~jeB擾܂B
     *
     * @param code R[h
     * @return R~jeBAȂ <code>null</code>
     */
    Community findByCode(String code);

    /**
     * [UɂJ̑SR~jeB̃Xgo^̍~Ŏ擾܂B
     *
     * @return R~jeBXg
     */
    List<Community> findPublicCommunities();

    /**
     * [UɂJ̃R~jeBw萔_Ɏ擾܂B
     *
     * @param max ő吔
     * @return R~jeBXg
     */
    List<Community> findPublicCommunitiesRandomly(int max);

    /**
     * Xbh擾܂B݂XbhłĂAw肵R~jeBɑĂȂ
     * <code>null</code> Ԃ܂B
     *
     * @param communityId R~jeB ID
     * @param threadId Xbh ID
     * @return XbhAȂ <code>null</code>
     */
    Thread findThread(int communityId, int threadId);

    /**
     * R~jeBXbhQ擾܂B
     *
     * @param id R~jeB ID
     * @return XbhXg
     */
    List<Thread> findThreads(int id);

    /**
     * ${this.ownerId}  ${this.overview.ownerId} 
     * ${this.overview.authroId} ɐݒ肵܂B${this.readAccessControl} 
     * ${this.overview.readAccessControl} ɐݒ肵܂B${this.writeAccessControl}
     *  ${this.overview.writeAccessControl} ɐݒ肵܂B
     */
    @Override
    void update(Community community);

    /**
     * w肵R~jeBփ[UQo^܂B
     *
     * @param userId [U ID
     * @param communityId R~jeB ID
     * @require ${this.findMyCommunity(userId)} not contains ${communityId}
     */
    void registerMyCommunity(int userId, int communityId);

    /**
     * [U̎Q̃R~jeBXg擾܂B
     *
     * @param userId [U ID
     * @return R~jeBXg
     */
    List<Community> findMyCommunies(int userId);

    /**
     * R~jeBɏĂ郆[U ID ̈ꗗ擾܂B
     *
     * @param communityId R~jeB ID
     * @return [U ID ̈ꗗ
     */
    List<Integer> findCommunityUserIds(int communityId);

    /**
     * w肵R~jeB烆[Uމ܂B
     *
     * @param userId [U ID
     * @param communityId R~jeB ID
     * @require ${this.findMyCommunity(userId)} contains ${communityId}
     */
    void deleteMyCommunity(int userId, int communityId);
}
